
=encoding UTF-8
=cut

=head1 Название

QBit::Application::Model::YandexLangDetect - работа с бибилиотекой для определения языка
пользователя

http://doc.yandex-team.ru/lib/lang-detect/

http://wiki.yandex-team.ru/AlekseyPonomarev/lang-detect

=head1 SYNOPSYS

=cut

package QBit::Application::Model::YandexLangDetect;

use qbit;

use base qw(QBit::Application::Model);

use langdetect;
use QBit::Application::Model::Yandex::CookieMy qw(parse_cookie_my);

sub accessor {'lang_detect'}

=head2 get_domain_region

Получаем домен и регион пользователя.

Пример вызова:
    ->get_domain_region(
        regions => [9999, 213, 1, 3, 225, 10001, 10000],  # список регионов ip адреса пользователя из геобазы, включая родительские
        supported => ['ru', 'en'],                        # список поддреживаемых сервисом языков
        host => 'beta.partner.yandex.ru',                 # урл сервиса
    );

Возвращает hashref:
    domain:  Домен.
    changed: 1 - если логикой библиотеки найден домен для переадресации.
    content-region: Регион пользователя (цифра, например, 24896).

=cut

sub get_domain_region {
    my ($self, %opts) = @_;

    my $ui = $self->_adapt_ui(%opts);
    return $self->{ld}->findDomainEx($ui);
}

=head2 get_lang_from_cookie_my

Получаем значене языка из куки my (http://wiki.yandex-team.ru/MyCookie)

=cut

sub get_lang_from_cookie_my {
    my ($cookie_value) = @_;
    my $setuphash = parse_cookie_my($cookie_value // '');
    return $setuphash->{'39'}->[1] || 0;

}

=head2 get_user_lang

    ->get_user_lang(
        regions => [9999, 213, 1, 3, 225, 10001, 10000],  # список регионов ip адреса пользователя из геобазы, включая родительские
        supported => ['ru', 'en'],                        # список поддреживаемых сервисом языков
        accept_language => 'en-us,en;q=0.5',              # Значение заголовка 'Accept-Language'
        host => 'beta.partner.yandex.ru',                 # урл Яндекс.Сервиса
        cookie => 'YycCAAM2AQEA',                         # значение куки my
        default => 'ru',                                  # дефолтный язык для сервиса
    );

Возвращает скаляр с языком пользователя, например 'ru' или 'en'.

=cut

sub get_user_lang {
    my ($self, %opts) = @_;

    my $ui = $self->_adapt_ui(%opts);

    my $user_lang_ref = $self->{ld}->find($ui);

=begin comment

В $user_lang_ref будет помещено что-то вроде:

{
    'lang' => 'ru',
    'name' => 'Ru'
};

=end comment
=cut

    return $user_lang_ref->{lang};
}

=head2 get_user_lang_and_languages

Параметры аналогичны get_user_lang и list_user_lang

Определяет текущий язык пользователя и список рекомендуемых языков.

Возвращает массив: ($<текущий язык>, [<доступные языки>]) ('ru', ['ru', 'uk'])

=cut

sub get_user_lang_and_languages {
    my ($self, %opts) = @_;

    return ($self->get_user_lang(%opts), $self->list_user_lang(%opts));

}

=head2 get_yandex_domain

    get_yandex_domain('beta.partner.yandex.ru');     # yandex.ru
    get_yandex_domain('beta.partner.yandex.com.tr'); # yandex.com.tr

=cut

sub get_yandex_domain {
    my ($server_name) = @_;
    $server_name =~ /(yandex\.(:?ru|ua|com|com\.tr))$/;
    return $1 ? $1 : '';
}

sub init {
    my ($self) = @_;

    $self->{ld} = langdetect::lookup->new('/usr/share/yandex/lang_detect_data.txt');

    $self->SUPER::init();
}

=head2 list_user_lang

Параметры - аналогично get_user_lang

Результат - список доступных языков для пользовтеля

 [
    'ru',
    'kk',
 ]

=cut

sub list_user_lang {
    my ($self, %opts) = @_;

    my $list = $self->{ld}->list($self->_adapt_ui(%opts));

    return [map($_->{lang}, @$list)];
}

# приводит хэш к набору параметров для библиотеки
sub _adapt_ui {
    my ($self, %opts) = @_;

    return {
        'geo'           => $opts{regions},
        'filter'        => $opts{supported},
        'language'      => $opts{accept_language},
        'pass-language' => $opts{pass_language},
        'domain'        => get_yandex_domain($opts{host}),
        'cookie'        => get_lang_from_cookie_my($opts{cookie}),
        'default'       => $opts{default},
    };
}

TRUE;
