package QBit::Application::_Utils::TmpLocale;

use qbit;

use base qw(QBit::Class);

use Exception::Validation::BadArguments;

sub DESTROY {
    my ($self) = @_;

    $self->{'app'}->set_app_locale($self->{'old_locale'});
}

sub init {
    my ($self) = @_;

    my @missed_required_params = grep {!exists($self->{$_})} qw(app old_locale);
    throw Exception::Validation::BadArguments gettext('Missed requred fields "%s"', join(', ', @missed_required_params))
      if @missed_required_params;
}

TRUE;
