package QBit::System;

use strict;
use warnings;
use utf8;

use base qw(Exporter);

BEGIN {
    our (@EXPORT, @EXPORT_OK);

    @EXPORT = qw(
      get_hostname
      get_version
      run_shell
      );
    @EXPORT_OK = @EXPORT;
}

sub get_hostname {
    if (defined($ENV{'DEPLOY_POD_PERSISTENT_FQDN'}) && length($ENV{'DEPLOY_POD_PERSISTENT_FQDN'}) > 0) {
        return $ENV{'DEPLOY_POD_PERSISTENT_FQDN'};
    }

    my ($hostname, $attempts) = (undef, 3);

    while ($attempts) {
        if ($hostname = `hostname -f`) {
            undef($attempts);
        } else {
            $attempts--;
            sleep(1);
        }
    }

    $hostname // die "Can't get hostname";

    chomp($hostname);

    die 'hostname is empty string' unless length($hostname);

    return $hostname;
}

sub get_version {
    my $version;
    if (-f '/version') {
        $version = `cat /version`;
        chomp($version);
    } else {
        my $cmd    = "dpkg -s yandex-partners-frontend | grep '^Version:'";
        my $output = `$cmd`;
        ($version) = $output =~ /Version: (.*)/;
    }
    return $version;
}

sub run_shell {
    my ($shell_command, %opts) = @_;

    my $silent = $opts{'silent'};

    local $| = 1;
    local $/ = " ";

    print "$shell_command\n" unless $silent;
    open(my $fh, '-|', $shell_command) or die "OPEN: $!";

    my $result = '';
    while (my $line = <$fh>) {
        $result .= $line;
        print $line unless $silent;
    }

    unless (close($fh)) {
        if ($!) {
            die sprintf("Shell command `%s` error close: %s", $shell_command, $!);
        } elsif (!$opts{skip_exit_code}) {
            die sprintf("Shell command `%s` returned a non zero exit status: %d", $shell_command, $? >> 8);
        }
    }

    return $result;
}

1;
