package QBit::Validator::Type::Dict;

use qbit;

use base qw(QBit::Validator::Type);
__PACKAGE__->abstract_methods(qw(schema dict_accessor pk_name vtype));

use Exception::Validator;
use Exception::Validator::Fields;
use PiConstants qw($MAX_CPM);

sub get_template {
    my ($self)        = @_;
    my $schema        = $self->schema;
    my $dict_accessor = $self->dict_accessor;
    my $pk            = $self->pk_name;
    my $dict_key      = $self->dict_key;
    return {
        $self->vtype(),
        schema => $schema,
        check  => sub {
            my ($qv, $dict, $tmpl, @path) = @_;

            my $dict_list = $qv->get_stash(\@path) // (ref($dict) ? $dict : from_json($dict));

            my %uniq = ();
            for (my $i = 0; $i < @$dict_list; $i++) {
                if (defined($dict_list->[$i]->{cpm})
                    && ($MAX_CPM < $dict_list->[$i]->{cpm} || 0.001 > $dict_list->[$i]->{cpm}))
                {
                    $qv->_add_error(
                        {},
                        gettext("Field 'cpm' should be a positive number less than %d", $MAX_CPM),
                        [@path, $i, 'cpm']
                    );
                }
                $uniq{$dict_list->[$i]->{$dict_key}}++;
            }

            my @identical_records = sort grep {$uniq{$_} > 1} keys(%uniq);

            throw Exception::Validator::Fields gettext("Identical records found for id: %s",
                join(', ', @identical_records))
              if @identical_records;

            my %dict =
              map {$_->{$pk} => TRUE} @{
                $qv->app->app->$dict_accessor->get_all(
                    fields => [$pk],
                    filter => ['AND', [{$pk => [sort keys(%uniq)]}, [$pk => '<>' => '0']]]
                )
              };

            if (keys(%uniq) != keys(%dict)) {
                throw Exception::Validator::Fields gettext("Entry with id: '%s' not found",
                    join(', ', sort grep {!$dict{$_}} keys(%uniq)));
            }
          }
    };
}

sub dict_key {'id';}

sub _get_options {[]}

sub _get_options_name {qw()}

TRUE;
