package QBit::Validator::Type::adaptive_height;

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator;
use Exception::Validator::Fields;

use PiConstants qw($BLOCK_TYPE_LIMITS);

sub get_template {
    return {
        type  => 'scalar',
        check => sub {
            my ($qv, $height) = @_;

            my $direct_block = $qv->data->{'direct_block'} // $qv->data->{'type'} // '';
            my $block_limits = $BLOCK_TYPE_LIMITS->{$direct_block} // {};

            my ($min_height, $max_height) = @$block_limits{qw( min_height  max_height )};

            if ($direct_block eq 'horizontal') {
                return TRUE if defined($height) && $height eq '';

                throw Exception::Validator::Fields gettext('Height of block must be a positive integer')
                  if !$height || $height !~ /^[1-9]\d*$/;

                throw Exception::Validator::Fields gettext('Height of block must be from %d to %d', $min_height,
                    $max_height)
                  unless $height >= $min_height && $height <= $max_height;

            } elsif ($direct_block eq 'adaptive') {

                my ($max_height_coef, $min_square, $max_square_coef) =
                  @$block_limits{qw( max_height_coef  min_square  max_square_coef )};

                throw Exception::Validator::Fields gettext('Height of block must be a positive integer')
                  if !$height || $height !~ /^[1-9]\d*$/;

                my $width = $qv->data->{'adaptive_width'}
                  || throw Exception::Validator::Fields gettext('Settings "adaptive_height" depends by adaptive width');
                my $limit = $qv->data->{'limit'}
                  // throw Exception::Validator::Fields gettext('Settings "adaptive_height" depends by max ad count');

                $max_height = $max_height_coef * $limit;

                if ($height < $min_height) {
                    throw Exception::Validator::Fields gettext('Minimal height of block must be greater than %s px',
                        $min_height);
                } elsif ($height > $max_height) {
                    throw Exception::Validator::Fields gettext('Height must be not more %s px', $max_height);
                }

                my $square     = $width * $height;
                my $max_square = $max_square_coef * $limit;

                if ($square < $min_square) {
                    throw Exception::Validator::Fields gettext(
                        'Square of block is too small. Increase a size of block.');
                } elsif ($square > $max_square) {
                    throw Exception::Validator::Fields gettext(
'Square of block is too large for chosen number of ads. Increase nubmer of ads or decrease size of block.'
                    );
                }
            } elsif ($direct_block eq 'motion' || $direct_block eq 'extensibleMobile') {

                return TRUE if defined($height) && $height eq '';

                throw Exception::Validator::Fields gettext('Height of block must be a positive integer')
                  if !$height || $height !~ /^[1-9]\d*$/;

                if ($height < $min_height) {
                    throw Exception::Validator::Fields gettext('Minimal height of block must be greater than %s px',
                        $min_height);
                } elsif ($height > $max_height) {
                    throw Exception::Validator::Fields gettext('Height must be not more %s px', $max_height);
                }

            } else {
                throw Exception::Validator::Fields gettext(
                    'Settings "adaptive_height" only for adaptive or horizontal or motion block')
                  if $height;
            }

            return TRUE;
        },
    };
}

sub _get_options {[]}

sub _get_options_name {qw()}

TRUE;
