package QBit::Validator::Type::adaptive_width;

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator;
use Exception::Validator::Fields;

use PiConstants qw($BLOCK_TYPE_LIMITS);

sub get_template {
    return {
        type  => 'scalar',
        check => sub {
            my ($qv, $width) = @_;

            my $direct_block = $qv->data->{'direct_block'} // $qv->data->{'type'} // '';
            my $block_limits = $BLOCK_TYPE_LIMITS->{$direct_block} // {};

            if ($direct_block eq 'adaptive') {

                throw Exception::Validator::Fields gettext('Width of block must be a positive integer')
                  if !$width || $width !~ /^[1-9]\d*$/;

                my $height = $qv->data->{'adaptive_height'}
                  || throw Exception::Validator::Fields gettext('Settings "adaptive_width" depends by adaptive height');
                my $limit = $qv->data->{'limit'}
                  // throw Exception::Validator::Fields gettext('Settings "adaptive_width" depends by max ad count');

                my ($min_width, $max_width_coef, $min_square, $max_square_coef) =
                  @$block_limits{qw( min_width  max_width_coef  min_square  max_square_coef )};

                my $max_width = $max_width_coef * $limit;

                if ($width < $min_width) {
                    throw Exception::Validator::Fields gettext('Minimal width of block must be greater than %s px',
                        $min_width);
                } elsif ($width > $max_width) {
                    throw Exception::Validator::Fields gettext('Width must be not more %s px', $max_width);
                }

                my $square     = $width * $height;
                my $max_square = $max_square_coef * $limit;

                if ($square < $min_square) {
                    throw Exception::Validator::Fields gettext(
                        'Square of block is too small. Increase a size of block.');
                } elsif ($square > $max_square) {
                    throw Exception::Validator::Fields gettext(
'Square of block is too large for chosen number of ads. Increase nubmer of ads or decrease size of block.'
                    );
                }
            } else {
                throw Exception::Validator::Fields gettext('Settings "adaptive_width" only for adaptive block')
                  if $width;
            }

            return TRUE;
        },
    };
}

sub _get_options {[]}

sub _get_options_name {qw()}

TRUE;
