package QBit::Validator::Type::bk_data;

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator;
use Exception::Validator::Fields;

use QBit::Validator::Type::bk_data::block;

sub get_template {
    return {
        type  => 'json',
        msg   => gettext('Incorrect custom bk data'),
        check => sub {
            my ($qv, $bk_data, $tmpl, @path) = @_;

            my $bk_data_structure;
            try {
                $bk_data_structure = from_json($bk_data);
                $qv->set_stash(\@path, $bk_data_structure);
            }
            catch {
                throw Exception::Validator::Fields gettext('Incorrect json');
            };

            \&QBit::Validator::Type::bk_data::block::validate($qv, $bk_data_structure);
        },
        extra => TRUE,
    };
}

sub _get_options {[]}

sub _get_options_name {qw()}

TRUE;
