package QBit::Validator::Type::bk_data::page;

use qbit;

use Exception::Validator;
use Exception::Validator::Fields;

use PiConstants qw($VIP_PROTECTED_MAX_PAGE_ID);

our @NOT_INTERNAL_PAGES = (242, 245);

sub validator {
    my ($qv, $bk_data, $tmpl, @path) = @_;

    my @fingerprint_prefix = ('Validator', 'bk_data', 'page');

    # TargetType - нужно в валидировать в ПИ, не забыть про годмод пэйджей
    # требуется хранить историю
    # у нас это не хранится - это вычисляемое поле от модели
    # наверное можно использовать pagesbs

    # Dsp+PageID - погрепать и птоврить в ПИ: Parameter 'DSPPageID' in SSPInfo table for this SSPID incorrect - ticket
    # ssp_seller->{$page->{seller_id}}->{dsp_page_id} - dsp_page_id?
    # у нас нет этой информации - dsp_page_id

    # Your PartnerID($partner_id) != PartnerID($pages_partner_id->{$page_id}) for this Page($page_id)
    # проверка на смену владельца площадки

    # is_ssp
    if ($qv->app->isa('Application::Model::Page::SSP')) {
        # Parameters 'SSPPageToken' and 'SSPID' is required - должны быть оба указаны
        unless (defined($bk_data->{SSPPageToken}) && defined($bk_data->{SSPID})) {
            throw Exception::Validator::Fields "Parameters 'SSPPageToken' and 'SSPID' is required";
        }
        if (ref $bk_data->{SSPPageToken} ne 'ARRAY' || (grep {!$_} @{$bk_data->{SSPPageToken}})) {
            throw Exception::Validator::Fields "Some token in parameter 'SSPPageToken' incorrect";
        }
        # Ругаемся если в SSPPageMapping уже есть запись для пришедшего SSPID и Token, но для другого PageID
        if (my @p = _check_sspid_token($qv, $bk_data)) {
            throw Exception::Validator::Fields "Exists SSPID with this Token for PageID=" . join(',', @p),
              sentry => {fingerprint => [@fingerprint_prefix, 'Exists SSPID with this Token for PageID']};
        }
    } else {
        if (exists($bk_data->{SSPPageToken}) || exists($bk_data->{SSPID})) {
            throw Exception::Validator::Fields "Parameters 'SSPPageToken' or 'SSPID' is excess";
        }
    }

    # You don't have permissions to edit this page($page_id)
    # # Запрет на редактирование внутренних PageID
    # if (
    #     $page_id > 0
    #         && $page_id <= 1000
    #         && $page_id != 242
    #         && $page_id != 245
    #
    # ) {
    if (   $bk_data->{PageID} > 0
        && $bk_data->{PageID} <= $VIP_PROTECTED_MAX_PAGE_ID
        && !in_array($bk_data->{PageID}, \@NOT_INTERNAL_PAGES))
    {
        throw Exception::Validator::Fields "You don't have permissions to edit this page($bk_data->{PageID})",
          sentry => {fingerprint => [@fingerprint_prefix, 'permissions to edit this page']};
    }

    # Undefined or wrong ProductType
    # # ProductType
    # if (
    #     defined($page->{ProductType})
    #         && (
    #         $product_type ne 'video'
    #             && $product_type ne 'mobile'
    #             && $product_type ne 'search'
    #             && $product_type ne 'context'
    #             && $product_type ne 'indoor'
    #             && $product_type ne 'outdoor'
    #     )
    # ) {
    if (
        defined($bk_data->{ProductType})
        && !in_array(
            $bk_data->{ProductType},
            ['video', 'mobile', 'search', 'context', 'indoor', 'outdoor', 'distribution']
        )
       )
    {
        throw Exception::Validator::Fields "Undefined or wrong ProductType: " . ($bk_data->{ProductType} // '<undef>'),
          sentry => {fingerprint => [@fingerprint_prefix, 'Undefined or wrong ProductType']};
    }

    # Invalid CPA value ($cpa) - must be >= 0 and <= 100
    if (defined $bk_data->{CPA} && ($bk_data->{CPA} < 0 || $bk_data->{CPA} > 100)) {
        throw Exception::Validator::Fields "Invalid CPA value ($bk_data->{CPA}) - must be >= 0 and <= 100",
          sentry => {fingerprint => [@fingerprint_prefix, 'Invalid CPA value']};
    }

    # 'StripeType' or 'StripeAnimation' key for PlaceID $Yabs::Transport::PI::Constants::STRIPE_PLACE_ID is undef
    # if ($page->{places}{1127})
    # exists StripeAnimation StripeType
    # Invalid 'StripeType' value - must be in (1,2,3,4)
    # Invalid 'StripeAnimation' value - must be in (0,1)
    if (exists $bk_data->{Places} && ref $bk_data->{Places} eq 'HASH' && exists $bk_data->{Places}{1127}) {
        my $sp = $bk_data->{Places}{1127};
        unless (defined $sp->{StripeType} && defined $sp->{StripeAnimation}) {
            throw Exception::Validator::Fields "'StripeType' or 'StripeAnimation' key for PlaceID 1127 is undef";
        }
        unless (in_array($sp->{StripeType}, [1 .. 4])) {
            throw Exception::Validator::Fields "Invalid 'StripeType' value - must be in (1,2,3,4)";
        }
        unless (in_array($sp->{StripeAnimation}, [0 .. 1])) {
            throw Exception::Validator::Fields "Invalid 'StripeAnimation' value - must be in (0,1)";
        }
    }

    my $options = {};
    for my $o (split(";", $bk_data->{Options} || "")) {
        my ($key, $value) = split("=", $o);
        $options->{$key} = $value;
    }

    # Invalid 'ReloadTimeout' value - must be in [1 .. 30]
    if (exists $options->{ReloadTimeout}) {
        unless (defined $options->{ReloadTimeout}
            && $options->{ReloadTimeout} =~ /^\d+$/
            && $options->{ReloadTimeout} >= 1
            && $options->{ReloadTimeout} <= 30)
        {
            throw Exception::Validator::Fields "Invalid 'ReloadTimeout' value - must be in [1 .. 30]";
        }
    }

    # Parameter 'Lang' is incorrect
    # my $lang             = $page->{Lang}; undef or ['ru,uk,en,by,kz,tr,tt']
    if (defined $bk_data->{Lang} && !in_array($bk_data->{Lang}, ['ru', 'uk', 'en', 'by', 'kz', 'tr', 'tt'])) {
        throw Exception::Validator::Fields "Parameter 'Lang' is incorrect";
    }

    # Parameter 'Store' incorrect
    # exists($page->{Store})                     $store ne "GooglePlay" && $store ne "AppStore"
    if (exists $bk_data->{Store}
        && !(defined $bk_data->{Store} && in_array($bk_data->{Store}, ["GooglePlay", "AppStore"])))
    {
        throw Exception::Validator::Fields "Parameter 'Store' incorrect";
    }

    if (exists $bk_data->{Slots}) {
        my $qv_json = QBit::Validator->new(
            app      => $qv,
            data     => $bk_data->{Slots},
            template => {type => 'page_slots'}
        );

        if ($qv_json->has_errors) {
            foreach my $error ($qv_json->get_fields_with_error) {
                $qv->_add_error($tmpl, $error->{msgs}->[0], [@path, @{$error->{path}}]);
            }
        }
    }

    my $app = $qv->app;
    for my $model ($qv->app->get_block_models) {
        my $bdk = $model->get_bk_block_data_key;
        next unless exists $bk_data->{$bdk};
        for my $block_data (values %{$bk_data->{$bdk}}) {
            my $accessor = $block_data->{BlockModel};
            $qv->app($app->app->$accessor);
            # QBit::Validator::Type::bk_data::block->validate($qv,$block_data);
        }
    }
    $qv->app($app);

    return TRUE;
}

sub _check_sspid_token {
    my ($qv, $bk_data) = @_;

    my $pn  = $qv->app->ssp_links->get_campaign_id_field;
    my $res = $qv->app->ssp_links->partner_db_table->get_all(
        fields => [$pn],
        filter => [
            AND => [
                [seller_id => '='  => \$bk_data->{SSPID}],
                [$pn       => '!=' => \undef],
                [$pn       => '!=' => \$bk_data->{PageID}],
                [OR => [map {json_contains => ['tokens', {json_array => [\$_]}]}, @{$bk_data->{SSPPageToken}}]]
            ]
        ],
    );

    return map {$_->{$pn}} @$res;
}

TRUE;
