package QBit::Validator::Type::block_preset;

use qbit;

use base qw(QBit::Validator::Type);

use Partner::BlockPreset;

sub get_template {
    return {
        type  => 'hash',
        extra => TRUE,
        check => sub {
            my ($qv, $data, $template, @path) = @_;

            my $preset = Partner::BlockPreset->build_and_validate($qv->app->app, $data);

            if (my $errors = $preset->get_errors()) {
                $qv->add_errors_from_other_qv(\@path, $errors);
            }
        },
    };
}

sub _get_options {[]}

sub _get_options_name {qw()}

TRUE;
