package QBit::Validator::Type::brands;

use qbit;

use base qw(QBit::Validator::Type::Dict);

sub schema        {'brands'}
sub dict_accessor {'tns_dict_brand'}
sub pk_name       {'bid'}
sub dict_key      {'bid'}              # front is sending brands with this key: {"bid":"533910","blocked":0,"cpm":1111}

sub vtype {
    return (
        type => 'array',
        all  => {
            type   => 'hash',
            fields => {
                bid     => {type => 'int_un',},
                blocked => {type => 'boolean'},
                cpm     => {
                    type     => 'cpm',
                    optional => TRUE,
                },
            },
            check => sub {
                throw Exception::Validator::Fields gettext("Unexpected field 'cpm' when 'blocked' is true")
                  if defined $_->{cpm} and $_->{blocked};
                throw Exception::Validator::Fields gettext("Field 'cpm' required when 'blocked' is false")
                  if not defined $_->{cpm} and not $_->{blocked};
              }
        },
    );
}

TRUE;
