package QBit::Validator::Type::bundle_id;

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator;
use Exception::Validator::Fields;

sub get_template {
    return {
        type  => 'scalar',
        check => sub {
            my ($qv, $bundle_id) = @_;

            my $store_id_field_name = $qv->app->accessor() eq 'mobile_app' ? 'type' : 'store_id';

            throw Exception::Validator::Fields gettext("No store provided")
              unless defined $qv->data->{$store_id_field_name};

            throw Exception::Validator::Fields gettext("Wrong bundle_id '%s' (store_id=%s)", $bundle_id,
                $qv->data->{$store_id_field_name})
              unless get_bundle_id($bundle_id, $qv->data->{$store_id_field_name});
          }
    };
}

sub _get_options {[]}

sub _get_options_name {qw()}

TRUE;
