package QBit::Validator::Type::cpm_zero;

#integer unsigned

use qbit;

use base qw(QBit::Validator::Type);
use PiConstants qw($MAX_CPM);

sub get_template {
    return {
        type   => 'scalar',
        min    => 0,
        max    => $MAX_CPM,
        regexp => qr/\A(0|[1-9][0-9]*|[0-9]+\.[0-9]{1,3})\z/,
        msg    => gettext("Field 'cpm' should be a positive number less than %d", $MAX_CPM),
    };
}

sub _get_options {[]}

sub _get_options_name {qw()}

TRUE;
