package QBit::Validator::Type::date;

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator;

my $OPTIONS = [{name => 'optional', required => TRUE}, {name => 'format'},];

sub optional {
    my ($self, $qv, $data, $template, $option, @path_field) = @_;

    if (ref($data)) {
        $qv->_add_error($template, gettext('Data must be SCALAR'), \@path_field);

        return FALSE;
    }

    if ($template->{$option} && !defined($data)) {
        $qv->_add_ok(\@path_field);

        return FALSE;
    } elsif (!$template->{$option} && !defined($data)) {
        unless (exists($template->{'eq'})) {
            $qv->_add_error($template, gettext('Data must be defined'), \@path_field);

            return FALSE;
        }
    }

    return TRUE;
}

sub format {
    my ($self, $qv, $data, $template, $option, @path_field) = @_;

    throw Exception::Validator gettext('Option "%s" must be SCALAR', $option)
      if ref($template->{$option});

    unless (check_date($data, iformat => $template->{$option})) {
        $qv->_add_error($template, gettext('Got value "%s" do not fit the format "%s"', $data, $template->{$option}),
            \@path_field);

        return FALSE;
    }

    return TRUE;
}

sub _get_options {
    return $OPTIONS;
}

sub _get_options_name {
    return map {$_->{'name'}} @$OPTIONS;
}

TRUE;
