package QBit::Validator::Type::domain;

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator::Fields;

my $OPTIONS = [];

sub get_template {
    return {
        check => sub {
            my ($qv, $value) = @_;

            my $widget = $qv->app->DOES('Application::Model::Role::Block::Has::ContentWidget');
            my $res = get_domain_or_error($value, widget => $widget, www => $widget);

            throw Exception::Validator::Fields $res->{error}
              if exists($res->{error});
            throw Exception::Validator::Fields gettext("Domain '%s' is not normalized", $value)
              unless $res->{ok} eq $value;
        },
    };
}

sub _get_options {[]}

sub _get_options_name {()}

TRUE;
