package QBit::Validator::Type::gps;

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator;
use Exception::Validator::Fields;

use Scalar::Util qw(looks_like_number);

sub get_template {
    return {
        type  => 'scalar',
        check => sub {
            my ($qv, $gps) = @_;

            throw Exception::Validator::Fields gettext(
'GPS coordinate should consists of latitude and longitude separated by comma (ex: "55.751244,37.618423").'
            ) unless $gps;

            my ($latitude, $longitude) = split(/,/, $gps, 2);

            throw Exception::Validator::Fields gettext('Latitude should be a float number between -90 and 90.')
              if !looks_like_number($latitude) || $latitude < -90 || $latitude > 90;

            throw Exception::Validator::Fields gettext('Longitude should be a float number between -180 and 180.')
              if !looks_like_number($longitude) || $longitude < -180 || $longitude > 180;
          }
    };
}

sub _get_options {[]}

sub _get_options_name {qw()}

TRUE;
