package QBit::Validator::Type::json;

use qbit;

use base qw(QBit::Validator::Type);

use JSV::Validator;

use lib::abs;

use Exception::Validator;
use Exception::Validator::Fields;

#order is important
my $OPTIONS = [{name => 'schema'}, {name => 'sub_template'},];

sub get_template {
    return {
        type  => 'scalar',
        check => sub {
            my ($validator, $data, $template, @path) = @_;

            return TRUE unless defined($data);

            try {
                $validator->set_stash(\@path, from_json($data));
            }
            catch {
                throw Exception::Validator::Fields gettext('Incorrect json');
            };
        },
    };
}

sub sub_template {
    my ($self, $qv, $data, $template, $option, @path_field) = @_;

    return TRUE unless defined($data);

    my $sub_template = $template->{'sub_template'};

    throw Exception::Validator gettext('Option "sub_template" must be HASH', $option)
      unless ref($sub_template) eq 'HASH';

    utf8::decode($data);
    my $json_data = from_json($data);

    my $sub_qv = QBit::Validator->new(
        data     => $json_data,
        template => $sub_template,
        app      => $self,
        throw    => FALSE
    );

    my @errors = $sub_qv->get_fields_with_error();
    if (@errors) {
        foreach my $error (@errors) {
            foreach my $msg (@{$error->{'msgs'}}) {
                $qv->_add_error($template, $msg, [@path_field, @{$error->{'path'}}]);
            }
        }
        return FALSE;
    }

    return TRUE;
}

sub schema {
    my ($self, $qv, $data, $template, $option, @path_field) = @_;

    return TRUE unless defined($data);

    throw Exception::Validator gettext('Key "%s" must be defined', $option)
      unless defined($template->{$option});

    my $schema = $template->{$option};

    unless (ref($template->{$option})) {
        $schema = from_json(readfile(lib::abs::path("/JsonSchemas/$template->{$option}.json")));
    }

    JSV::Validator->load_environments("draft4");
    my $v = JSV::Validator->new(environment => "draft4");

    my $json_data = $qv->get_stash(\@path_field);

    unless (defined($json_data)) {
        try {
            $json_data = from_json($data);
        }
        catch {
            throw Exception::Validator::Fields gettext('Incorrect json');
        };

        $qv->set_stash(\@path_field, $json_data);
    }

    my $vr = $v->validate($schema, $json_data);
    if ($vr) {
        return TRUE;
    } else {
        $qv->_add_error($template, gettext("Not match with schema\n%s", to_json($vr->errors, pretty => TRUE)),
            \@path_field);

        return FALSE;
    }
}

sub _get_options {return clone($OPTIONS);}

sub _get_options_name {
    return map {$_->{'name'}} @$OPTIONS;
}

TRUE;
