package QBit::Validator::Type::json_boolean;

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator::Fields;

sub get_template {
    return {
        type  => 'ref',
        check => sub {
            my ($validator, $data, $template, @path) = @_;

            if (ref($data) !~ /^JSON::(?:(?:XS)|(?:PP))::Boolean$/) {
                throw Exception::Validator::Fields gettext('Must be json boolean');
            }
        },
        msg => gettext('Must be json boolean'),
    };
}

sub _get_options {[]}

sub _get_options_name {qw()}

TRUE;
