package QBit::Validator::Type::page_patch;

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator;
use Exception::Validator::Fields;

use PiConstants qw($PAGE_KEYS_TRANSFORM);

my $PAGE_PATCH_IMMUTABLE_KEYS = {
    # поля которые меняют суть пейджа
    map {$_ => 1} qw( PageID  TargetType  Domain  IsYandexPage )
};

my $PAGE_PATCH_FORBIDDEN_KEYS = {
    %$PAGE_PATCH_IMMUTABLE_KEYS,
    # поля которые меняют регистр при отправке в БК
    map {$_ => 1} grep {$_ ne $PAGE_KEYS_TRANSFORM->{$_}} keys %$PAGE_KEYS_TRANSFORM,
};

sub get_template {
    return {
        type  => 'json',
        check => \&_check_page_patch,
        extra => TRUE,
    };
}

sub _check_page_patch {
    my ($qv, $patch, $tmpl, @path) = @_;

    my $is_validation = 0;
    my $is_add        = 0;
    my $is_edit       = 0;
    if (!$qv->app->hook_stash->inited) {
        $is_validation = 1;
    } else {
        if ($qv->app->hook_stash->mode('edit')) {
            $is_edit = 1;
        } elsif ($qv->app->hook_stash->mode('add')) {
            $is_add = 1;
        }
    }

    my $patch_data = from_json($patch // '{}');

    my $is_distribution = $qv->app->accessor() eq 'distribution_campaign' ? 1 : 0;

    # При создании в модели Дистрибуция можно присылать поля Domain и IsYandexPage
    my @allowed_add_fields = $is_distribution ? (qw(Domain IsYandexPage)) : ();

    # Т.к. в модели Дистрибуции поля Domain и IsYandexPage живут только в поле patch,
    # то нельзя запрещать их присылать при редактировании, иначе они вообще пропадют из bk_data,
    # но нужно проверять что они не изменилось
    my @allowed_edit_fields = $is_distribution ? (qw(Domain IsYandexPage)) : ();

    my $forbidden_keys = clone $PAGE_PATCH_FORBIDDEN_KEYS;
    if ($is_validation) {
        # При валидации все поля уже подтянуты из базы
        delete $forbidden_keys->{$_} foreach (keys %$PAGE_PATCH_IMMUTABLE_KEYS);
    } else {
        if ($is_add && @allowed_add_fields) {
            delete $forbidden_keys->{$_} foreach (@allowed_add_fields);
        } elsif ($is_edit && @allowed_edit_fields) {
            my $curr_patch = from_json($qv->get_stash('current')->{patch} // '{}');

            foreach my $key (@allowed_edit_fields) {
                my $cur_val = $curr_patch->{$key} // '';
                my $new_val = $patch_data->{$key} // '';
                if ($cur_val ne $new_val) {
                    $qv->_add_error($tmpl, gettext('"%s" cannot be changed', $key), [@path, $key]);
                }
                delete $forbidden_keys->{$key};
            }
        }
    }

    my $is_domain_optional     = $is_distribution ? 0 : 1;
    my $is_partner_id_optional = $is_distribution ? 0 : 1;

    my @target_type_values = $qv->app->accessor() =~ /search/ ? (2) : (3);
    @target_type_values = (8) if $is_distribution;

    foreach my $key (keys %{$patch_data}) {
        if (grep {!$_} split(/\./, $key)) {
            $qv->_add_error($tmpl, gettext('The path before dot cannot be empty'), [@path, $key]);
        }

        if ($key =~ /\.__(DEL|PUSH)__$/) {
            $qv->_add_error($tmpl, gettext('Data must be ARRAY'), [@path, $key])
              unless ref($patch_data->{$key}) eq 'ARRAY';
        }
    }

    my $qv_json = QBit::Validator->new(
        app      => $qv,
        data     => $patch,
        template => {
            type         => 'json',
            sub_template => {
                type     => 'hash',    # декодим JSON и проверяем как hash
                optional => 1,
                extra    => 1,
                fields   => {
                    "Domain" => {
                        type     => 'scalar',
                        optional => $is_domain_optional,
                    },
                    IsYandexPage => {
                        type     => 'scalar',
                        optional => 1,
                        in       => [1, 0]
                    },
                    Mirrors => {
                        type     => 'scalar',
                        optional => 1,
                    },
                    Options => {
                        type     => 'scalar',
                        optional => 1,
                        check    => sub {
                            my (undef, $val) = @_;
                            my @param_pairs = split /;/, $val;
                            foreach my $param_pair (@param_pairs) {
                                my @chunks = split /=/, $param_pair;
                                throw Exception::Validator::Fields gettext('Field "Options" has wrong format"')
                                  unless @chunks == 2;
                            }
                          }
                    },
                    OrigPageID => {
                        type     => 'scalar',
                        optional => 1,
                        regexp   => qr/\A-?[0-9]+\z/,
                        msg      => gettext('Must be a signed integer'),
                    },
                    # {Enable => [sort keys(%enable)], Disable => [sort keys(%disable)]};
                    PageOptions => {
                        type     => 'hash',
                        optional => 1,
                        fields   => {
                            Disable => {
                                optional => 1,
                                type     => 'array',
                            },
                            Enable => {
                                optional => 1,
                                type     => 'array',
                            },
                        }
                    },
                    PartnerID => {
                        type     => 'int_un',
                        min      => 0,
                        optional => $is_partner_id_optional,
                    },
                    Places => {
                        type     => 'hash',
                        extra    => 1,
                        optional => 1,
                    },
                    PPCTotal => {
                        type     => 'int_un',
                        min      => 0,
                        optional => 1,
                    },
                    state => {
                        type     => 'scalar',
                        optional => 1,
                        in       => [-1, 0, 1],
                    },
                    Slots => {
                        type     => 'page_slots',    # см QBit::Validator::Type::page_slots
                        optional => 1,
                    },
                    TargetType => {
                        type     => 'scalar',
                        optional => 1,
                        in       => \@target_type_values,
                    },
                    '__DEL__' => {
                        type               => 'array',
                        optional           => 1,
                        not_any_before_dot => $forbidden_keys
                    }
                },
                not_any_before_dot => $forbidden_keys,
            }
        }
    );

    if ($qv_json->has_errors) {
        foreach my $error ($qv_json->get_fields_with_error) {
            $qv->_add_error($tmpl, $error->{msgs}->[0], [@path, @{$error->{path}}]);
        }
    }
}

sub _get_options {[]}

sub _get_options_name {qw()}

TRUE;
