package QBit::Validator::Type::page_slots;

# Валидирует структуру поля "Slots" в bk_data

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator;
use Exception::Validator::Fields;

sub get_template {
    #    "Slots": [
    #      {
    #        "Description": "Спецразмещение",
    #        "SlotID": 1,
    #        "Total": 0,
    #        "TypeID": 1
    #        "Sequences": [
    #          {
    #            "ExceptionID": 0,
    #            "OrderType": 0,
    #            "PlaceID": 542,
    #            "PlaceSelect": 5,
    #            "PrintSeqID": 1,
    #            "PrintSlotID": 1,
    #            "SequenceCheck": 0,
    #            "SequenceID": 1
    #            "SequenceLimit": 0,
    #            "SequenceType": "premium",
    #          },
    #          ...
    #        ],
    #      },
    #      ...
    #    ]
    return {
        type => 'array',
        all  => {
            type   => 'hash',
            extra  => 1,
            fields => {
                Description => {type => 'scalar', optional => 1,},
                Sequences   => {
                    type => 'array',
                    all  => {
                        type   => 'hash',
                        extra  => 1,
                        fields => {
                            # см https://yql.yandex-team.ru/Operations/YiBquFZ1O_jZtbci-3O5Oe2kLmUUZJfnYunFp8qsA2c=
                            PlaceID       => {type => 'int_un', min => 1},
                            PlaceSelect   => {type => 'int_un'},
                            PrintSeqID    => {type => 'int_un', min => 1},
                            PrintSlotID   => {type => 'int_un'},
                            SequenceCheck => {type => 'int_un'},
                            SequenceID    => {type => 'int_un', min => 1},
                            SequenceLimit => {type => 'int_un'},
                            SequenceType  => {
                                type => 'scalar',
                                # см https://yql.yandex-team.ru/Operations/Yh-ejtJwbFJB9rH3ca0ggiW-urx_iPZsHfG8xoddDZY=
                                in => [
                                    "", qw(
                                      dynamic
                                      dynamic-right
                                      dynamic-south
                                      guarantee
                                      guarantee-right
                                      guarantee-south
                                      na
                                      premium
                                      visual
                                      )
                                ]
                            },
                        }
                    }
                },
                SlotID => {type => 'int_un'},
                Total  => {type => 'int_un'},
                TypeID => {type => 'int_un'},
            }
        },
    };
}

sub _get_options {[]}

sub _get_options_name {qw()}

TRUE;
