package QBit::Validator::Type::phone;

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator::Fields;

my $OPTIONS = [];

sub get_template {
    return {
        check => sub {
            my ($qv, $value) = @_;

            my $res = get_normalized_phone_or_error($value);

            throw Exception::Validator::Fields $res->{error}
              if exists($res->{error});
            throw Exception::Validator::Fields "Phone '$value' is not normalized"
              unless $res->{ok} eq $value;
        },
    };
}

sub _get_options {[]}

sub _get_options_name {()}

TRUE;
