package QBit::Validator::Type::pixels;

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator;
use Exception::Validator::Fields;

my $pixel_sub_template = {
    type     => 'array',
    optional => TRUE,
    all      => {
        type   => 'hash',
        fields => {
            type => {in => ['view', 'open_player']},
            url  => {
                check => sub {
                    my $domain = get_domain($_[1]);

                    throw Exception::Validator::Fields gettext('Param "url" must be link.')
                      unless $_[1] eq '' || defined($domain);
                },
            },
        },
    },
};

sub get_template {
    return {
        type   => 'hash',
        fields => {
            1000 => $pixel_sub_template,
            1001 => $pixel_sub_template,
        },
    };
}

sub _get_options {[]}

sub _get_options_name {qw()}

TRUE;
