package QBit::Validator::Type::publicid;

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator::Fields;

sub get_template {
    return {
        type  => 'scalar',
        check => sub {
            my ($validator, $data) = @_;

            my $public_id = $validator->app->_split_id($data);

            throw Exception::Validator::Fields gettext('Invalid public_id "%s"', $data) if ref($public_id) ne 'HASH';
        },
    };
}

sub _get_options {[]}

sub _get_options_name {qw()}

TRUE;
