package QBit::Validator::Type::ref;

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator;

#order is important
my $OPTIONS = [{name => 'optional', required => TRUE}, {name => 'ref_value',},];

sub optional {
    my ($self, $qv, $data, $template, $option, @path_field) = @_;

    if ($template->{$option} && !defined($data)) {
        $qv->_add_ok(\@path_field);

        return FALSE;
    } elsif (!$template->{$option} && !defined($data)) {
        $qv->_add_error($template, gettext('Data must be defined'), \@path_field);

        return FALSE;
    }

    unless (ref($data)) {
        $qv->_add_error($template, gettext('Data must be REF'), \@path_field);

        return FALSE;
    }

    return TRUE;
}

sub ref_value {
    my ($self, $qv, $data, $template, $option, @path_field) = @_;

    throw Exception::Validator gettext('Option "%s" must be type "Scalar"', $option)
      if !defined($template->{$option}) || ref($template->{$option}) ne '';

    if (ref($data) ne $template->{$option}) {
        $qv->_add_error($template, gettext('Ref value must be "%s"', $template->{$option}), \@path_field);

        return FALSE;
    }

    return TRUE;
}

sub _get_options {
    my ($self) = @_;

    return clone($OPTIONS);
}

sub _get_options_name {
    return map {$_->{'name'}} @$OPTIONS;
}
