package QBit::Validator::Type::resolution;

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator;
use Exception::Validator::Fields;

sub get_template {
    return {
        type  => 'scalar',
        check => sub {
            my ($qv, $resolution) = @_;

            throw Exception::Validator::Fields gettext(
                'Resolution should be in format "1024x768" where 1024 - width and 768 - height.')
              unless $resolution && $resolution =~ /^\d+x\d+\z/;

            my ($width, $height) = split(/x/, $resolution, 2);

            throw Exception::Validator::Fields gettext('Width of block must be a positive integer')
              if !$width || $width !~ /^[1-9][0-9]*\z/;

            throw Exception::Validator::Fields gettext('Height of block must be a positive integer')
              if !$height || $height !~ /^[1-9][0-9]*\z/;

            my $page_id = $qv->data->{page_id}
              // throw Exception::Validator::Fields gettext('Field "resolution" depends on "page_id"');
            my $page_model    = $qv->app->page;
            my $facility_type = $page_model->get_all(
                filter => {page_id => $page_id},
                fields => ['facility_type']
            )->[0]->{facility_type};
            throw Exception::Validator::Fields gettext('Page not found for page_id "%s"', $page_id)
              unless defined $facility_type;
            my $resolutions = $page_model->facility_type()->{$facility_type}->{resolutions} // [];
            return unless @$resolutions;
            throw Exception::Validator::Fields gettext("Only %s resolutions allowed.", join ',', @$resolutions)
              unless in_array($resolution, $resolutions);
          }

    };
}

sub _get_options {[]}

sub _get_options_name {qw()}

TRUE;
