package QBit::Validator::Type::widget;

use qbit;

use base qw(QBit::Validator::Type);

use Exception::Validator::Fields;

sub get_template {
    return {
        type   => 'hash',
        fields => {
            accessor => {
                type    => 'scalar',
                len_max => 255,
            },
            type => {
                type    => 'scalar',
                len_max => 255,
            },
            deletable => {
                type     => 'scalar',
                in       => ["", 0, 1],
                optional => 1,
            },
            first => {
                type     => 'scalar',
                in       => ["", 0, 1],
                optional => 1,
            },
            resizable => {
                type     => 'scalar',
                in       => ["", 0, 1],
                optional => 1,
            },
            settings => {
                type     => 'hash',
                extra    => 1,
                optional => 1,
            },
            server_settings => {
                type     => 'hash',
                extra    => 1,
                optional => 1,
            },
            width => {
                type     => 'scalar',
                in       => [qw(full half)],
                optional => 1,
            },
        }
    };
}

sub _get_options {[]}

sub _get_options_name {qw()}

TRUE;
