package QBit::WebInterface;

use POSIX qw(strftime setlocale LC_TIME);

use qbit;

use QBit::WebInterface::Response;

use Utils::Logger qw(ERROR WARN);

use Exception::Denied;
use Exception::Request::UnknownMethod;
use Exception::WebInterface::Controller::CSRF;

eval {require Exception::WebInterface::Controller::CSRF; require Exception::Request::UnknownMethod};

sub break {
    my ($self, @data) = @_;

    $self->{'__BREAK_PROCESS__'} = 1;
    return @data;
}

sub build_response {
    my ($self) = @_;

    $self->pre_run();

    throw gettext('No request object') unless $self->request;
    $self->response(QBit::WebInterface::Response->new());

    my $cmds = $self->get_cmds();
    my ($path, $cmd) = $self->get_cmd();

    $cmd = $cmds->{$path}{'__DEFAULT__'}{'name'} if $cmd eq '';
    $cmd = '' unless defined($cmd);

    $self->set_option(cur_cmd     => $cmd);
    $self->set_option(cur_cmdpath => $path);

    if (exists($cmds->{$path}{$cmd})) {
        try {
            my $cmd = $cmds->{$path}{$cmd};

            my $controller = $cmd->{'package'}->new(
                app   => $self,
                path  => $path,
                attrs => $cmd->{'attrs'}
            );

            $self->{'__BREAK_PROCESS__'} = 0;
            $self->pre_cmd($controller);

            unless ($self->{'__BREAK_PROCESS__'}) {
                $controller->{'__BREAK_CMD__'} = FALSE;
                $controller->pre_cmd() if $controller->can('pre_cmd');

                unless ($controller->{'__BREAK_CMD__'}) {
                    if ($controller->attrs()->{'SAFE'}) {
                        throw Exception::WebInterface::Controller::CSRF gettext('CSRF has been detected')
                          unless $controller->check_anti_csrf_token($self->request->param(sign => ''),
                            url => $self->get_option('cur_cmdpath') . '/' . $self->get_option('cur_cmd'));
                    }

                    my $out;
                    open(local *STDOUT, '>:utf8', \($out = ""));
                    select STDOUT;
                    $| = 1;

                    my @data = $cmd->{'sub'}($controller);

                    if (defined(my $method = $cmd->{'process_method'})) {
                        $controller->$method(@data);
                    }

                    WARN($out) if $out;
                }
            }

            $self->post_cmd();
        }
        catch Exception::Request::UnknownMethod with {
            $self->response->status(400);
        }
        catch Exception::Validation with {
            $self->response->status(400);
        }
        catch Exception::Denied with {
            $self->response->status(403);
        }
        catch {
            my ($e) = @_;

            $self->exception_dumper->dump_as_html_file($e);
            $self->response->status(500);
        }
        finally {
            my ($e) = @_;

            # 'finally' is always executed, even if no exceptions
            if (defined(blessed($e))) {
                my ($type, $message);

                # hide internal error messages
                if ($self->response->status =~ /^5/) {
                    $type    = 'Internal';
                    $message = 'Internal Error';
                } else {
                    $type    = blessed($e);
                    $message = $e->message();
                }
                $message = html_encode($message);

                # a special form of error for XHR requests with JSON answers
                if (($self->request->http_header('Accept') || '') =~ /(application\/json|text\/javascript)/) {
                    $self->response->status(200);
                    $self->response->content_type("$1; charset=UTF-8");
                    $self->response->data(to_json({error => $message}));
                } else {
                    $self->response->data($message);
                }
            }
        };
    } else {
        $self->response->status(404);
    }

    my $ua = $self->request->http_header('User-Agent');
    $self->response->headers->{'Pragma'} = ($ua =~ /MSIE/) ? 'public' : 'no-cache';

    $self->response->headers->{'Cache-Control'} =
      ($ua =~ /MSIE/)
      ? 'must-revalidate, post-check=0, pre-check=0'
      : 'no-cache, no-store, max-age=0, must-revalidate';

    my $tm   = time();
    my $zone = (strftime("%z", localtime($tm)) + 0) / 100;
    my $loc  = setlocale(LC_TIME);
    setlocale(LC_TIME, 'en_US.UTF-8');
    my $GMT = strftime("%a, %d %b %Y %H:%M:%S GMT", localtime($tm - $zone * 3600));
    setlocale(LC_TIME, $loc);

    $self->response->headers->{'Expires'} = $GMT;

    $self->post_run();
}

sub default_cmd {throw 'Abstract metod'}

sub form_fields { }

sub get_cmd {throw 'Abstract metod'}

sub get_cmds {
    my ($self) = @_;

    my $cmds = {};

    package_merge_isa_data(
        ref($self),
        $cmds,
        sub {
            my ($package, $res) = @_;

            my $pkg_cmds = package_stash($package)->{'__CMDS__'} || {};
            foreach my $path (keys(%$pkg_cmds)) {
                foreach my $cmd (keys(%{$pkg_cmds->{$path}})) {
                    $cmds->{$path}{$cmd} = $pkg_cmds->{$path}{$cmd};
                }
            }
        },
        __PACKAGE__
    );

    return $cmds;
}

sub make_cmd {throw 'Abstract metod'}

sub post_cmd { }

sub pre_cmd { }

sub request {
    my ($self, $request) = @_;
    return defined($request) ? $self->{'__REQUEST__'} = $request : $self->{'__REQUEST__'};
}

sub response {
    my ($self, $response) = @_;
    return defined($response) ? $self->{'__RESPONSE__'} = $response : $self->{'__RESPONSE__'};
}

sub _escape_filename {
    my ($self, $filename) = @_;

    $filename =~ s{"}{\\"}g;
    $filename =~ s{\r}{}g;
    $filename =~ s{\n}{}g;

    return $filename;
}

sub _get_new_cmd {
    my ($self, $new_cmd, $cur_cmd) = @_;

    $cur_cmd = '' unless defined($cur_cmd);

    return defined($new_cmd) ? $new_cmd : $cur_cmd;
}

sub _get_new_path {
    my ($self, $new_path, $cur_path) = @_;

    $cur_path = '' unless defined($cur_path);

    return defined($new_path) && length($new_path) ? $new_path : $cur_path;
}

TRUE;
