package QBit::WebInterface::Controller::BEMHTML::Form::Field::address;

use qbit;

use base qw(QBit::WebInterface::Controller::Form::Field);

use Exception::Form;

sub as_html {
    my ($self) = @_;

    my $regions = $self->form->controller->app->kladr->get_towns_by_code()->[0];
    unshift(@$regions, ['', '--------']);

    return ${
        $self->form->controller->_process_template('common/form/address.bem.tt2',
            vars => {field => $self, regions => $regions})
      };
}

sub process {
    my ($self, $controller) = @_;

    $self->{'value'} = {
        raw => {
            map {$_ => $controller->request->param($self->name . '__' . $_)}
              qw(region district city town street streettext home building construction flat_type flat postcode)
        }
    };

    $self->{'value'}{'flat_type'} = $self->{'value'}{'raw'}{'flat_type'};

    $self->{'value'}{'code'} = $self->form->controller->app->kladr->extract_street_code(
        {map {$_ => $self->{'value'}{'raw'}{$_}} qw(street town city district region)});

    my $addr_hs = $self->form->controller->app->kladr->validate_address($self->{'value'}{'code'},
        map {$self->{'value'}{'raw'}{$_}} qw{home building construction flat postcode})
      || throw Exception::Form gettext('Invalid address');

    $self->{'value'}{'address_hs'} = $self->form->controller->app->kladr->get_addr_hash($addr_hs, TRUE);
    $self->{'value'}{'address'} = $self->form->controller->app->kladr->get_addr_str($addr_hs);

    throw Exception::Form gettext('Required field')
      if $self->{'required'} && !$self->{'value'}{'address'} =~ /\S/;

    throw Exception::Form gettext('House field required')
      if $self->{'required'} && !$self->{'value'}{'raw'}{'home'} =~ /\S/;

    $self->{'check'}($self, $self->{'value'})
      if exists($self->{'check'});
}

1;
