package QBit::WebInterface::Controller::BEMHTML::Form::Field::authority_document;

use qbit;

use base qw(QBit::WebInterface::Controller::Form::Field);

use Clone qw(clone);

use Exception::Form::authority_document;

my %DOC_TYPES = (
    # Устав
    1 => {label => d_gettext('Charter'), persons => ['ur'], no_number => TRUE, no_date => TRUE},

    # Доверенность
    2 => {label => d_gettext('Power of attorney'), persons => ['ur']},

    # Приказ
    3 => {label => d_gettext('Order'), persons => ['ur']},

    # Распоряжение
    4 => {label => d_gettext('Instruction'), persons => ['ur']},

    # Положение о филиале
    5 => {label => d_gettext('Branch regulations'), persons => ['ur']},

    # Свидетельство о регистрации
    6 => {label => d_gettext('Registration certificate'), persons => ['ip']},

    # Договор
    7 => {label => d_gettext('Contract')},

    # Протокол
    8 => {label => d_gettext('Protocol')},
);

sub as_html {
    my ($self) = @_;

    return ${
        $self->form->controller->_process_template('common/form/authority_document.bem.tt2',
            vars => {field => $self, doc_types => $self->_get_doc_types(subtype => $self->{'subtype'})})
      };
}

sub process {
    my ($self, $controller) = @_;

    $self->{'value'} = {map {$_ => $controller->request->param($self->name . '__' . $_)} qw(type number date)};
    $_ = trim($_) foreach grep {defined($_)} values(%{$self->{'value'}});

    my $field_error;

    my $doc_type_id = $self->{'value'}{'type'} // '';
    my $doc_type = $self->_get_doc_type_by_id($doc_type_id, subtype => $self->{'subtype'});

    $field_error->{'type'} = gettext('Invalid document type') unless $doc_type;

    if ($doc_type->{'no_number'}) {
        delete($self->{'value'}{'number'});
    } else {
        $field_error->{'number'} = gettext('Required field "Number"') unless $self->{'value'}{'number'} =~ /\S/;
    }

    if ($doc_type->{'no_date'}) {
        delete($self->{'value'}{'date'});
    } else {
        if ($self->{'value'}{'date'} =~ /\S/) {
            $field_error->{'date'} = gettext('Inval field "Date"')
              unless check_date($self->{'value'}{'date'}, iformat => 'db');
        } else {
            $field_error->{'date'} = gettext('Required field "Date"');
        }
    }

    throw Exception::Form::authority_document $field_error if $field_error;
}

=begin comment _get_doc_type_by_id

    my $hash_ref = $self->_get_doc_type_by_id(
        subtype => 'ur',
    );

Это вернет:

    {
        label     => "Устава",
        no_date   => 1,
        no_number => 1,
        value     => 1,
    },

Если нет юридического документа с указанным id, который доступен для
указанного типа формы собстенности, то возвращается undef.

Параметр subtype сейчас являтеся опциоанльным, в будуем нужно сделать его
обязательным.

=end comment

=cut

sub _get_doc_type_by_id {
    my ($self, $type_id, %opts) = @_;

    my $doc_types_hash = clone(\%DOC_TYPES);

    my $element;

    if ($opts{'subtype'}) {
        $element = $doc_types_hash->{$type_id};
        unless (ref($element->{'persons'}) eq 'ARRAY' && in_array($opts{'subtype'}, $element->{'persons'})) {
            $element = undef;
        }

    } else {
        $element = $doc_types_hash->{$type_id};
    }

    if ($element) {
        $element->{'value'} = $type_id;
        $element->{'label'} = $element->{'label'}();
        delete $element->{'persons'};

        return $element;
    } else {
        return undef;
    }

}

=begin comment _get_doc_types


    my $array_ref = $self->_get_doc_types(
        subtype => 'ur',
    );

Возвращает arrayref с хешами данных юридических документов, которые доступны
для указанного типа формы собстенности (юридическое лицо, индивидульный
предприниматель, физическое лицо).

Сейчас параметр subtype является опциональным, если его не указать, то будут
возвращены все юридические документы. В будущем нужно сделать использование
параметра subtype обязательным.

Пример возвращаемых данных:

    [
        {
            label     => "Устава",
            no_date   => 1,
            no_number => 1,
            value     => 1,
        },
        {
            label => "Доверенности",
            value => 2,
        },
        ...
    ]

=end comment

=cut

sub _get_doc_types {
    my ($self, %opts) = @_;

    my $doc_types_hash = clone(\%DOC_TYPES);
    my $doc_types;

    foreach my $type_id (sort {$a <=> $b} keys %$doc_types_hash) {
        my $element = $doc_types_hash->{$type_id};

        if (exists($opts{'subtype'}) && defined($opts{'subtype'})) {
            if (ref($element->{'persons'}) eq 'ARRAY' && in_array($opts{'subtype'}, $element->{'persons'})) {

                $element->{'value'} = $type_id;
                $element->{'label'} = $element->{'label'}();
                delete $element->{'persons'};
                push @$doc_types, $element;

            }
        } else {
            $element->{'value'} = $type_id;
            $element->{'label'} = $element->{'label'}();
            delete $element->{'persons'};
            push @$doc_types, $element;
        }
    }

    return $doc_types;
}

TRUE;
