package QBit::WebInterface::Controller::BEMHTML::Form::Field::bank_account;

use qbit;

use base qw(QBit::WebInterface::Controller::Form::Field);

use Exception::Form;

sub as_html {
    my ($self) = @_;

    return ${$self->form->controller->_process_template('common/form/bank_account.bem.tt2', vars => {field => $self})};
}

sub process {
    my ($self, $controller) = @_;

    $self->{'value'} = {map {$_ => $controller->request->param($self->name . '__' . $_) // ''} qw(bic account)};

    my $field_error;

    unless ($self->{'value'}{'bic'} =~ /\S/) {
        $field_error = gettext('Required field "BIC"');
        $self->{'control_errors'}->{'bic'} = gettext('Required field');
    }
    unless ($self->{'value'}{'account'} =~ /\S/) {
        $field_error = gettext('Required field "Operating account"');
        $self->{'control_errors'}->{'account'} = gettext('Required field');
    }

    unless ($self->{'control_errors'}->{'bic'}) {
        my $bank_info = $self->form->controller->app->banks->get($self->{'value'}{'bic'},
            fields => [qw(pretty_name correspondentaccount)]);

        unless ($bank_info) {
            $field_error = gettext('Invalid BIC');
            $self->{'control_errors'}->{'bic'} = gettext('Invalid BIC');
        }

        push_hs($self->{'value'}, $bank_info);

        unless ($self->{'control_errors'}->{'account'}) {
            unless ($self->__check_account_bic($self->{'value'}{'account'}, $self->{'value'}{'bic'})) {
                $field_error = gettext('Invalid operating account');
                $self->{'control_errors'}->{'account'} = gettext('Invalid operating account');
            }
        }
    }

    if ($field_error) {
        throw Exception::Form $field_error;
    }
}

sub __check_account_bic {
    my ($self, $acc, $bik) = @_;

    return FALSE unless length($acc) == 20 && $acc =~ /^\d+$/;

    my @k = (7, 1, 3);
    my $sum;

    if ($bik =~ /00\d$/) {
        $acc = '0' . substr($bik, 4, 2) . $acc;
    } else {
        $acc = substr($bik, -3) . $acc;
    }

    for (my $i = 0; $i < length($acc); $i++) {
        $sum += substr($acc, $i, 1) * $k[$i % 3];
    }

    return $sum % 10 == 0;
}

1;
