package QBit::WebInterface::Controller::BEMHTML::Form::Field::block_appearance;

use qbit;

use base qw(QBit::WebInterface::Controller::Form::Field);

use Exception::Form::block_appearance;

use PiConstants qw($HORIZONTAL_LIMITS);

sub as_html {
    my ($self) = @_;

    return ${
        $self->form->controller->_process_template('common/form/block_appearance.bem.tt2',
            vars => {field => $self, type => $self->get_type})
      };
}

sub check {
    my ($self) = @_;

    my %color_fields = map {$_ => TRUE} $self->get_color_fields;

    my %boolean_fields = map {$_ => TRUE} $self->get_boolean_fields;

    my %border_type = (none => TRUE, block => TRUE, ad => TRUE, collapse => TRUE);
    my %title_font_size = (1 => TRUE, 2 => TRUE, 3 => TRUE);
    my %font_family =
      ('' => TRUE, arial => TRUE, 'courier new' => TRUE, tahoma => TRUE, 'times new roman' => TRUE, verdana => TRUE);
    my %font_size = ('0.8' => TRUE, '0.9' => TRUE, 1 => TRUE, '1.1' => TRUE, '1.2' => TRUE);

    my %errors = ();

    foreach ($self->get_fields) {
        next unless defined($self->{'value'}{$_});

        if ($color_fields{$_} && $self->{'value'}{$_} !~ m/^[0-9ABCDEF]{6}$/) {
            $errors{$_} = gettext('Invalid format color');
        } elsif ($boolean_fields{$_} && $self->{'value'}{$_} !~ m/^[01]$/) {
            $errors{$_} = gettext('Invalid value for boolean field');
        } elsif ($_ eq 'border_type' && !$border_type{$self->{'value'}{$_}}) {
            $errors{'border_type'} = gettext('Invalid value');
        } elsif ($_ eq 'title_font_size' && !$title_font_size{$self->{'value'}{$_}}) {
            $errors{'title_font_size'} = gettext('Invalid value');
        } elsif ($_ eq 'font_family' && !$font_family{$self->{'value'}{$_}}) {
            $errors{'font_family'} = gettext('Invalid value');
        } elsif ($_ eq 'font_size' && !$font_size{$self->{'value'}{$_}}) {
            $errors{'font_size'} = gettext('Invalid value');
        } elsif (
            $_ eq 'adaptive_height'
            && $self->{'value'}{$_}
            && !(
                   $self->{'value'}{$_} >= $HORIZONTAL_LIMITS->{'min_height'}
                && $self->{'value'}{$_} <= $HORIZONTAL_LIMITS->{'max_height'}
            )
          )
        {
            $errors{'adaptive_height'} = gettext(
                'Height of block must be from %d to %d',
                $HORIZONTAL_LIMITS->{'min_height'},
                $HORIZONTAL_LIMITS->{'max_height'}
            );
        }
    }

    throw Exception::Form::block_appearance \%errors
      if %errors;
}

sub process {
    my ($self, $controller) = @_;

    $self->{'value'} = {map {$_ => $controller->request->param($self->name . '__' . $_)} $self->get_fields};

    foreach ($self->get_boolean_fields) {
        if ($self->{'value'}{$_}) {
            $self->{'value'}{$_} = 1;
        } else {
            $self->{'value'}{$_} = 0;
        }
    }

    $self->check;
}

TRUE;
