package QBit::WebInterface::Controller::BEMHTML::Form::Field::date;

=encoding UTF-8

=head1 DESCRIPTION

Поле принимает дату в формате YYYY-MM-DD

В контрол можно передать опциональные параметры (если не указаны, то
дополнительных проверок не будет).

 * min_date - при валидации значение должно быть больше или равно этому значению
 * max_date - при валидации значение должно меньше или равно этому значению

=cut

use qbit;
use base qw(QBit::WebInterface::Controller::Form::Field);

use Exception::Form;

sub as_html {
    my ($self) = @_;

    return ${$self->form->controller->_process_template('common/form/date.bem.tt2', vars => {field => $self})};
}

sub check {
    my ($self) = @_;

    throw Exception::Form gettext("Incorrect date") unless check_date($self->value, iformat => 'db');

    if (defined($self->{min_date})) {
        my $date = ref($self->{min_date}) eq 'CODE' ? $self->{min_date}->() : $self->{min_date};
        my $result = dates_delta_days($self->value, $date, iformat => 'db');
        throw Exception::Form gettext("Incorrect date") if $result > 0;
    }

    if (defined($self->{max_date})) {
        my $date = ref($self->{max_date}) eq 'CODE' ? $self->{max_date}->() : $self->{max_date};
        my $result = dates_delta_days($self->value, $date, iformat => 'db');
        throw Exception::Form gettext("Incorrect date") if $result < 0;
    }
}

1;
