package QBit::WebInterface::Controller::BEMHTML::Form::Field::daterange;

use qbit;

use base qw(QBit::WebInterface::Controller::Form::Field);

use Exception::Form;

sub as_html {
    my ($self) = @_;

    return ${$self->form->controller->_process_template('common/form/daterange.bem.tt2', vars => {field => $self})};
}

sub process {
    my ($self, $controller) = @_;

    my $type = $controller->request->param($self->name . "__name");

    my $from;
    my $to;

    my @allowed_types = (
        'today',   'yesterday', 'daybeforeyesterday', 'sevendays', 'thisweek', 'lastweek',
        'tendays', 'thismonth', 'lastmonth',          '30days',    '90days',   'thisyear',
        'pastyear',
    );

    if ($type eq "other") {

        $from = $controller->request->param($self->name . '__' . 'from');
        $to   = $controller->request->param($self->name . '__' . 'to');

        throw Exception::Form gettext("No 'from'") if !$from;
        throw Exception::Form gettext("No 'to'")   if !$to;

        my $compare_result = compare_dates(
            $from,
            $to,
            iformat1 => 'db',
            iformat2 => 'db'
        );

        if ($compare_result == 1) {
            throw Exception::Form gettext("Date 'to' is before date 'from'");
        }

    } elsif (in_array($type, \@allowed_types)) {
        ($from, $to) = name2dates($type, '', '', iformat => 'db', oformat => 'db');
    } else {
        throw Exception::Form gettext("Unknown daterange");
    }

    $self->{'value'}{'type'} = $type;
    $self->{'value'}{'from'} = $from;
    $self->{'value'}{'to'}   = $to;

    return FALSE;
}

1;
