package QBit::WebInterface::Controller::BEMHTML::Form::Field::entity_types;

=encoding UTF-8

=head1 DESCRIPTION

После того как пользователь заполнил поле, $self->value() будет возвращать
структуру типа:

    {
        # ID формы собственности из хеша %ENTITY_TYPES
        entity_type_id => 1,

        # Текст из инпута, если выбран пункт "Другая форма собственности"
        # Этот элемент пристутствует только в случае если entity_type_id = 6
        # Значение - всегда строка, состоящая как минимум из одного символа
        # Максимальная длина - 255 символов
        entity_type_other => 'Some text',
    }

=cut

use qbit;

use Clone qw(clone);

use base qw(QBit::WebInterface::Controller::Form::Field);

use Exception::Form;
use Exception::Validation::BadArguments;

# Ключи хеша соответствуют id которые передаются в поле orgtype в ручку
# Баланса CreateOrUpdatePartner
my %ENTITY_TYPES = (
    # ООО
    1 => {label => d_gettext('ООО')},

    # ЗАО
    2 => {label => d_gettext('ЗАО')},

    # ПБОЮЛ
    # Закомментировано, так как этот тип формы собственности был
    # закоментирован в ПИ1
    # 3 => {label => d_gettext('ПБОЮЛ')},

    # ОАО
    4 => {label => d_gettext('ОАО')},

    # Индивидуальный предприниматель
    5 => {label => d_gettext('ИП')},

    # Другая
    6 => {label => d_gettext('Other')},
);

sub as_html {
    my ($self) = @_;

    my $entity_types;

    foreach my $key (sort {$a <=> $b} keys %ENTITY_TYPES) {
        push @$entity_types,
          {
            label => $ENTITY_TYPES{$key}->{label},
            value => $key,
          };
    }

    my $data = ${
        $self->form->controller->_process_template(
            'common/form/entity_types.bem.tt2',
            vars => {
                field        => $self,
                entity_types => $entity_types,
            }
        )
      };

    return $data;
}

sub get_entity_type_name {
    my ($self, $id) = @_;

    my $entity_types = clone(\%ENTITY_TYPES);

    if (exists($entity_types->{$id})) {
        my $name = $entity_types->{$id}->{label}->();
        return $name;
    } else {
        throw Exception::Validation::BadArguments gettext("Unknown id");
    }
}

sub process {
    my ($self, $controller) = @_;

    my $input = {map {$_ => $controller->request->param($self->name . '__' . $_)} qw(type_id text)};

    $self->{'value'} = {
        entity_type_id => $input->{'type_id'},
        (($input->{'type_id'} eq '6') ? (entity_type_other => $input->{'text'}) : ()),
    };

    throw Exception::Form gettext('Incorrect value') unless exists $ENTITY_TYPES{$input->{'type_id'}};

    if ($input->{'type_id'} eq '6') {
        throw Exception::Form gettext('Incorrect value') if length($input->{'text'}) < 1;
        throw Exception::Form gettext('Incorrect value') if length($input->{'text'}) > 255;
    }

    return FALSE;
}

1;
