package QBit::WebInterface::Controller::BEMHTML::Form::Field::iban;

use qbit;
use base qw(QBit::WebInterface::Controller::BEMHTML::Form::Field::input);

use Business::IBAN;

use Exception::Form;

sub check {
    my ($self) = @_;

    $self->SUPER::check();

    my $iban = Business::IBAN->new();
    throw Exception::Form gettext("Incorrect IBAN")
      if $self->{'value'} && !$iban->valid($self->{'value'});
}

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    $self->{'length'} = 32;
}

1;
