package QBit::WebInterface::Controller::BEMHTML::Form::Field::iban_or_account;

=encoding UTF-8

=head1 DESCRIPTION

После того как пользователь заполнил поле $self->value() будет возвращать
структуру типа:

    {
        # Правильное, провалидированное значение.
        # Тут может быть либо account, либо iban, но никогда не вместе.
        # Всегда должен быть либо account, либо iban.
        account => "12345",

        # "сырые" данные в том виде как их ввел пользователь
        raw     => {
            account => "12345",
            iban    => "",
        },
    }

=cut

use qbit;
use base qw(QBit::WebInterface::Controller::Form::Field);

use Business::IBAN;

use Exception::Form;

sub as_html {
    my ($self) = @_;

    return ${$self->form->controller->_process_template('common/form/iban_or_account.bem.tt2', vars => {field => $self})
      };
}

sub process {
    my ($self, $controller) = @_;

    $self->{'value'} = {raw => {map {$_ => $controller->request->param($self->name . '__' . $_)} qw(iban account)}};

    my $iban    = $self->value()->{'raw'}->{'iban'}    // '';
    my $account = $self->value()->{'raw'}->{'account'} // '';

    if (length($iban) > 0 && length($account) > 0) {
        throw Exception::Form gettext("You can't use both IBAN and Account");
    } elsif (length($iban) > 0) {
        my $bi = Business::IBAN->new();
        throw Exception::Form gettext("Incorrect IBAN") unless $bi->valid($iban);
        $self->{'value'}->{'iban'} = $iban;
    } elsif (length($account) > 0) {
        $self->{'value'}->{'account'} = $account;
    } else {
        throw Exception::Form gettext("You need to enter IBAN or Account");
    }

    return FALSE;
}

TRUE;
