package QBit::WebInterface::Controller::BEMHTML::Form::Field::inn;

use qbit;

use base qw(QBit::WebInterface::Controller::BEMHTML::Form::Field::input);

use Exception::Form;

sub check {
    my ($self) = @_;

    $self->SUPER::check();

    throw Exception::Form gettext('Invalid INN') unless __check_inn($self->{'value'});
}

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    $self->{'length'} //= 12;
}

sub __check_inn {
    my ($inn) = @_;

    if (
        $inn eq '7736207543'       # Yandex
        or $inn eq '7707083893'    # Sber
       )
    {
        return FALSE;
    }

    my @mno    = (3, 7, 2, 4, 10, 3, 5, 9, 4, 6, 8);
    my $cnt    = 0;
    my $newinn = '';
    return FALSE if length($inn) != 10 && length($inn) != 12 || $inn !~ /^\d+$/;

    if (length($inn) == 10) {
        @mno = splice(@mno, 2, 9);
        for (0 .. 8) {
            $cnt += substr($inn, $_, 1) * $mno[$_];
        }
        $newinn = substr($inn, 0, 9) . (($cnt % 11) % 10);
    } else {
        my $cnt1 = 0;
        for (0 .. 10) {
            $cnt1 += substr($inn, $_, 1) * $mno[$_];
        }
        @mno = splice(@mno, 1, 10);
        for (0 .. 9) {
            $cnt += substr($inn, $_, 1) * $mno[$_];
        }
        $newinn = substr($inn, 0, 10) . (($cnt % 11) % 10) . (($cnt1 % 11) % 10);
    }

    return $inn eq $newinn;
}

1;
