package QBit::WebInterface::Controller::BEMHTML::Form::Field::input;

use qbit;

use base qw(QBit::WebInterface::Controller::Form::Field::input);

use Exception::Form;

sub as_html {
    my ($self) = @_;

    return ${$self->form->controller->_process_template('common/form/input.bem.tt2', vars => {field => $self})};
}

sub process {
    my ($self, $controller) = @_;

    return $self->SUPER::process($controller) unless $self->{'i18n'};

    my $locales = $controller->app->get_option('locales', {});

    $self->{'value'} = {};

    foreach my $locale (keys(%$locales)) {
        $self->{'value'}{$locale} = $controller->request->param("$self->{'name'}.$locale", $self->{'value'} // '');

        $self->{'value'}{$locale} = trim($self->{'value'}{$locale}) if $self->{'trim'};
        $self->{'value'}{$locale} = $self->clean($self->{'value'}{$locale});
        $self->{'value'}{$locale} = $self->{'clean_func'}($self->{'value'}{$locale})
          if exists($self->{'clean_func'});

        throw Exception::Form gettext('Required field')
          if $self->{'required'} && !$self->{'value'}{$locale} =~ /\S/;
    }

    $self->check();
    $self->{'check'}($self, $self->{'value'})
      if exists($self->{'check'});
}

1;
