package QBit::WebInterface::Controller::BEMHTML::Form::Field::kpp;

use qbit;

use base qw(QBit::WebInterface::Controller::BEMHTML::Form::Field::input);

use Exception::Form;

sub check {
    my ($self) = @_;

    $self->SUPER::check();

    throw Exception::Form gettext('Invalid KPP') unless defined($self->{'value'}) && $self->{'value'} =~ /^\d{9}$/;
}

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    $self->{'length'} //= 9;
}

sub process {
    my ($self, $controller) = @_;

    my $entity_type_id = $controller->request->param('entity_types__type_id');

    if ($entity_type_id == 5) {
        $self->{'required'} = FALSE;
        $self->{'disabled'} = TRUE;
        $self->{'value'}    = '';
    } else {
        $self->{'required'} = TRUE;
        $self->{'disabled'} = FALSE;
        $self->{'value'}    = $controller->request->param('kpp');
        $self->check();
    }
}

TRUE;
