package QBit::WebInterface::Controller::BEMHTML::Form::Field::multi_checkbox;

use qbit;

use base qw(QBit::WebInterface::Controller::Form::Field);

use Exception::Form;

sub as_html {
    my ($self) = @_;

    foreach (@{$self->{'items'}}) {
        $_->{'checked'} = in_array($_->{'value'}, $self->{'value'} || []);
    }

    return ${$self->form->controller->_process_template('common/form/multi_checkbox.bem.tt2', vars => {field => $self})
      };
}

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    $self->{'items_value_key'} //= 'value';
    $self->{'items_label_key'} //= 'label';
}

sub process {
    my ($self, $controller) = @_;

    $self->SUPER::process($controller);

    $self->{'value'} = $controller->request->param_array($self->{'name'});

    throw Exception::Form gettext('Required field')
      if $self->{'required'} && !$self->{'value'};
}

TRUE;
