package QBit::WebInterface::Controller::BEMHTML::Form::Field::nr_address;

use qbit;

use base qw(QBit::WebInterface::Controller::Form::Field);

use Exception::Form;

sub as_html {
    my ($self) = @_;

    return ${$self->form->controller->_process_template('common/form/nr_address.bem.tt2', vars => {field => $self})};
}

sub process {
    my ($self, $controller) = @_;

    $self->{'value'} = {raw => {map {$_ => $controller->request->param($self->name . '__' . $_)} qw(postcode address)}};

    throw Exception::Form gettext('Address field is required')
      if $self->{'required'} && !$self->{'value'}{'raw'}{'address'} =~ /\S/;

    throw Exception::Form gettext('Postcode field is required')
      if $self->{'required'} && !$self->{'value'}{'raw'}{'postcode'} =~ /\S/;
}

1;
