package QBit::WebInterface::Controller::BEMHTML::Form::Field::number_and_optional_spaces;

use qbit;

use base qw(QBit::WebInterface::Controller::BEMHTML::Form::Field::input);

use Exception::Form;

=head1 DESCRIPTION

В $self->{count} должно быть число-сколько цифр принимает контрол.

Примеры валидных значений, когда $self->{count} = 4

 * 1234
 * 12 34
 * 1 2 3 4

=cut

=head1 check

=cut

sub check {
    my ($self) = @_;

    $self->SUPER::check();

    my $tmp_value = $self->value();
    $tmp_value =~ s/\s//g;

    my $length = $self->{count};

    throw 'Unknown length' if not defined $length;

    unless ($tmp_value =~ /^[0-9]{$length}$/) {
        throw Exception::Form gettext('Invalid number');
    }

}

1;
