package QBit::WebInterface::Controller::BEMHTML::Form::Field::pfr;

=encoding UTF-8

=head1 DESCRIPTION

После того как пользователь заполнил поле $self->value() будет возвращать
структуру типа:

    {
        # Сконтатенированное значение из тех данных что ввел пользователь
        # Это может не являтся корректным ПФР номером
        pfr => '112-233-445 95',

        # "сырые" данные в том виде как их ввел пользователь
        # нет гарантии что это правильные значения
        raw     => {
            pfr1 => 112,
            pfr2 => 233,
            pfr3 => 445,
            pfr4 => 95,
        },
    }

=cut

use qbit;
use base qw(QBit::WebInterface::Controller::Form::Field);

use Business::PFR;

use Exception::Form;

sub as_html {
    my ($self) = @_;

    return ${$self->form->controller->_process_template('common/form/pfr.bem.tt2', vars => {field => $self})};
}

sub check {
    my ($self) = @_;

    my $bp = Business::PFR->new(value => $self->value->{pfr},);

    throw Exception::Form gettext("Incorrect PFR") unless $bp->is_valid();

    return FALSE;
}

sub init {
    my ($self) = @_;

    $self->SUPER::init();
}

sub process {
    my ($self, $controller) = @_;

    my $raw = {map {("pfr$_" => $controller->request->param($self->name . "__pfr$_"))} (1 .. 4)};
    my $pfr = join('-', (map {$raw->{"pfr$_"}} (1 .. 3))) . ' ' . $raw->{pfr4};

    my $value = {
        pfr => $pfr,
        raw => $raw,
    };

    $self->{'value'} = $value;

    $self->check();
}

1;
