package QBit::WebInterface::Controller::BEMHTML::Form::Field::ph_payments;

=encoding UTF-8

=head1 DESCRIPTION

После того как пользователь заполнил поле $self->value() будет возвращать
структуру типа:

    {
        # может быть либо 'yamoney', либо 'sberbank', либо 'otherbank'
        type => 'yamoney',

        yamoney_account = '41002131301834',

        raw => {
            ...
        },
    }

Элемент raw пристутствует в value() в любом случае.

Остальные значения присутсвую только в том случае, если они валидные.

=cut

use qbit;
use base qw(QBit::WebInterface::Controller::BEMHTML::Form::Field::bank_account);

use Exception::Form;
use Exception::Validation::BadArguments;

sub as_html {
    my ($self) = @_;

    return ${$self->form->controller->_process_template('common/form/ph_payments.bem.tt2', vars => {field => $self})};
}

=head2 is_correct_ph_account

Проверка что расчетный счет подходит для физика.

Описание проверок в тикетах:

 * https://jira.yandex-team.ru/browse/BALANCE-9507
 * https://jira.yandex-team.ru/browse/PI-2577

=cut

sub is_correct_ph_account {
    my ($self, $account) = @_;

    return FALSE if $account =~ /^301/;
    return FALSE if $account =~ /^302/;
    return FALSE if $account =~ /^303/;
    return FALSE if $account =~ /^407/;

    if ($account =~ /^408/) {
        return TRUE  if $account =~ /^40817/;
        return FALSE if $account =~ /^40802/;
    }

    return TRUE;
}

sub is_correct_sberbank_person_account {
    my ($self, $account) = @_;

    # Лицевой счет
    # Состоит из 20 цифр или из 20 цифр и дополнительного кода, отделённого знаком "/"
    return $account =~ m{^[0-9]{20}(/[0-9]+)?$};
}

sub process {
    my ($self, $controller) = @_;

    my @fields = qw(
      type
      yamoney_account
      bankbic
      sberbank-person-account
      sberbank-account
      otherbank-account
      );

    my $raw = {map {$_ => $controller->request->param($self->name . '__' . $_)} @fields};
    $self->{'value'}{'raw'} = $raw;

    my $was_yamoney_error;
    my $was_sberbank_error;
    my $was_otherbank_error;

    if ($raw->{'type'} eq 'yamoney') {

        my @obligatory_fields = qw(
          fname
          lname
          mname
          passport-n
          passport-s
          );

        foreach my $field (@obligatory_fields) {
            throw Exception::Validation::BadArguments gettext("Field '%s' not defined")
              unless defined($controller->request->param($field));
        }

        my $is_account_identificated = $self->form->controller->app->yamoney->is_account_identificated(
            account    => $raw->{yamoney_account},
            lastname   => $controller->request->param('lname'),
            firstname  => $controller->request->param('fname'),
            middlename => $controller->request->param('mname'),
            passport_s => $controller->request->param('passport-s'),
            passport_n => $controller->request->param('passport-n'),
        );

        if ($is_account_identificated) {
            $self->{'value'}{'type'}            = 'yamoney';
            $self->{'value'}{'yamoney_account'} = $raw->{yamoney_account};
        } else {
            $self->{'control_errors'}{'yamoney_account'} = gettext("Incorrect Yandex.Money account number");
            $was_yamoney_error = TRUE;
        }

    } elsif ($raw->{'type'} eq 'sberbank') {

        if (length($raw->{'bankbic'}) == 0) {
            $self->{'control_errors'}{'bankbic'} = gettext('Required field');
            $was_sberbank_error = TRUE;
        }

        unless ($self->form->controller->app->banks->get($raw->{'bankbic'})) {
            $self->{'control_errors'}{'bankbic'} = gettext("Incorrect BIC");
            $was_sberbank_error = TRUE;
        }

        unless ($self->is_correct_sberbank_person_account($raw->{'sberbank-person-account'})) {
            $self->{'control_errors'}{'sberbank-person-account'} = gettext("Incorrect person account");
            $was_sberbank_error = TRUE;
        }

        unless ($self->__check_account_bic($raw->{'sberbank-account'}, $raw->{'bankbic'})) {
            $self->{'control_errors'}{'sberbank-account'} = gettext("Incorrect account");
            $was_sberbank_error = TRUE;
        }

        unless ($self->is_correct_ph_account($raw->{'sberbank-account'})) {
            $self->{'control_errors'}{'sberbank-account'} = gettext("Incorrect account");
            $was_sberbank_error = TRUE;
        }

        unless ($was_sberbank_error) {
            $self->{'value'}{'type'}                    = 'sberbank';
            $self->{'value'}{'bankbic'}                 = $raw->{'bankbic'};
            $self->{'value'}{'sberbank-person-account'} = $raw->{'sberbank-person-account'};
            $self->{'value'}{'sberbank-account'}        = $raw->{'sberbank-account'};
        }

    } elsif ($raw->{'type'} eq 'otherbank') {

        if (length($raw->{'bankbic'}) == 0) {
            $self->{'control_errors'}{'bankbic'} = gettext('Required field');
            $was_otherbank_error = TRUE;
        }

        unless ($self->form->controller->app->banks->get($raw->{'bankbic'})) {
            $self->{'control_errors'}{'bankbic'} = gettext("Incorrect BIC");
            $was_otherbank_error = TRUE;
        }

        unless ($self->__check_account_bic($raw->{'otherbank-account'}, $raw->{'bankbic'})) {
            $self->{'control_errors'}{'otherbank-account'} = gettext("Incorrect account");
            $was_otherbank_error = TRUE;
        }

        unless ($self->is_correct_ph_account($raw->{'otherbank-account'})) {
            $self->{'control_errors'}{'otherbank-account'} = gettext("Incorrect account");
            $was_otherbank_error = TRUE;
        }

        unless ($was_otherbank_error) {
            $self->{'value'}{'type'}              = 'otherbank';
            $self->{'value'}{'bankbic'}           = $raw->{'bankbic'};
            $self->{'value'}{'otherbank-account'} = $raw->{'otherbank-account'};
        }

    } else {
        throw Exception::Form gettext("Unknown type");
    }

    if ($was_yamoney_error || $was_sberbank_error || $was_otherbank_error) {
        throw Exception::Form gettext("Incorrect payment data");
    }

    return FALSE;
}

TRUE;
