package QBit::WebInterface::Controller::BEMHTML::Form::Field::rtb_multiformats;

use qbit;

use base qw(QBit::WebInterface::Controller::Form::Field);

use Exception::Form;

=head1 as_html

Метод as_html() возвращает bemjson дерево, с помощью которого отрисовывается
поле.

=cut

sub as_html {
    my ($self) = @_;

    $self->value({}) unless defined($self->value);

    $self->{'direct_blocks'} = [
        map {value => $_, label => $self->{'data'}->{'direct_blocks'}->{$_}->{'caption'}->()},
        sort keys %{$self->{'data'}->{'direct_blocks'}}
    ];
    $self->{'media_blocks'} = [
        map {value => $_, label => $self->{'data'}->{'media_blocks'}->{$_}->{'short_caption'}->()},
        keys %{$self->{'data'}->{'media_blocks'}}
    ];

    my @selected_dsp_blocks = @{$self->value->{'dsp_blocks'} // []};

    foreach my $dsp_block_id (keys %{$self->{data}->{dsp_blocks}}) {
        push @{$self->{dsp_blocks}},
          {
            value => $dsp_block_id,
            label => $self->{'data'}->{'dsp_blocks'}->{$dsp_block_id}->{'short_caption'}->(),
            ((in_array($dsp_block_id, \@selected_dsp_blocks)) ? (selected => 'selected') : ())
          };
    }

    return
      ${$self->form->controller->_process_template('common/form/rtb_multiformats.bem.tt2', vars => {field => $self,})};
}

=head1 process

Метод process() помещает в $self->value() структуру вида:

    {
        direct_block   "horizontal",
        limit          2,
        media_block    "300x300"
        dsp_blocks => [
            "240x400",
            "1000x120",
            "300x250",
        ],
        type    "horizontal",
    }

=cut

sub process {
    my ($self, $controller) = @_;

    my $prefix = $self->name . '__';

    my $input = {map {$_ => $controller->request->param("$prefix$_")} qw(direct_block media_block limit)};

    my $p = $controller->request->{'__PARAMS__'};
    my @dsp_blocks = map {@{$p->{$_}}} grep {$_ =~ /^${prefix}dsp_block/} keys %{$p};

    $input->{'dsp_blocks'} = \@dsp_blocks;

    # Конструктору кода нужно передавать параметр type
    $input->{'type'} = $input->{'direct_block'};

    $self->{'value'} = $input;

    throw Exception::Form gettext('Incorrect limit')
      unless $self->form->controller->app->internal_context_on_site_rtb->check_limit(%$input);

    return FALSE;
}

TRUE;
