package QBit::WebInterface::Controller::BEMHTML::Form::Field::stripe_appearance;

use qbit;

use base qw(QBit::WebInterface::Controller::Form::Field);

use Exception::Form::stripe_appearance;

sub as_html {
    my ($self) = @_;

    return ${
        $self->form->controller->_process_template('common/form/stripe_appearance.bem.tt2',
            vars => {field => $self, type => 'stripe'})
      };
}

sub check {
    my ($self) = @_;

    my %errors = ();

    foreach my $field_name ($self->get_fields) {
        $errors{$field_name} = gettext('Required field')
          unless defined($self->value->{$field_name})
              && length($self->value->{$field_name});
    }

    throw Exception::Form::stripe_appearance \%errors
      if %errors;
}

sub get_fields {
    return qw(disposition_id interaction_id type_id animation);
}

sub process {
    my ($self, $controller) = @_;

    foreach my $field_name ($self->get_fields()) {
        delete($self->{'value'}{$field_name});
        $self->{'value'}{$field_name} = $controller->request->param($self->name . '__' . $field_name);
    }

    $self->check;
}

TRUE;
