package QBit::WebInterface::Test::Request;

use qbit;

use base qw(QBit::WebInterface::Request);

sub http_header {
    my ($self, $name) = @_;

    my $value = $self->{'headers'}{$name};

    return defined($value) ? $value : '';
}

sub method {shift->{'method'}}

sub query_string {shift->{'query'}}

sub remote_addr {'127.0.0.1'}

sub scheme {shift->{'scheme'}}

sub server_name {'Test'}

sub server_port {0}

sub uri {
    my ($self) = @_;

    my $result = "/$self->{'path'}/$self->{'cmd'}";
    $result .= '?' . $self->{'query'} if defined($self->{'query'});
}

sub _read_from_stdin {
    my ($self, $buffer_ref, $size) = @_;

    return read($self->{'__STDIN__'}, $$buffer_ref, $size);
}

TRUE;
