(function () {
    'use strict';
    /* was used in b-table-cell-text in pi2 but replaced by b-form-multilang and refreshed b-table-cell-text */
    BEM.DOM.decl({
        block: 'b-form-input',
        modName: 'multilang',
        modVal: 'yes'
    }, {
        onSetMod: {
            js: function () {
                var that = this;
                // find elems for caching before DOM replacing
                this.elem('lang-input');

                this.vals = {};

                var multilangInput = this.elem('input', 'type', 'multilang');
                this.bindTo(multilangInput, 'focus', this.onFocus);
                this.bindTo(multilangInput, 'click', this.onInputClick);

                this.langs = this.findBlockOn('langs', 'b-popupa');

                this.langs.on('outside-click', function (e) {
                    e.preventDefault();
                    if ( !that.preventOutsideClick ) {
                        that.onCancel();
                    }
                    that.preventOutsideClick = false;
                });

                this.langs.on('hide', function () {
                    this.delMod('open');
                }, this);

                this.save = this.findBlockOn('save', 'b-form-button');
                this.save.on('click', this.onSave, this);

                this.cancel = this.findBlockOn('cancel', 'b-form-button');
                this.cancel.on('click', this.onCancel, this);

                this.addHiddens();
                if ( this.params.values ) {
                    this.setVals(this.params.values);
                }
            },
            open: {
                yes: function () {
                    this.elem('langs-box').width(this.elem('input').width());
                    this.langs.show(this.elem('input'));
                    this.afterCurrentEvent(function () {
                        this.findBlockOn(
                            this.elem('lang-input')
                                .eq(0),
                            'b-form-input'
                        ).setMod('focused', 'yes');
                    });
                },

                '': function () {
                    this.langs.hide();
                }
            }
        },
        destruct: function () {
            this.langs &&
                this.langs.destruct();

            this.__base.apply(this, arguments);
        },
        addHiddens: function () {
            var that = this;
            this.hiddens = {};
            that.elem('lang-input').each(function () {
                var l = that.getMod($(this), 'lang');
                that.hiddens[l] = $('<input type="hidden" name="' + that.params.name + '.' + l + '" />')
                    .appendTo(that.domElem);
            });
        },
        onInputClick: function () {
            this.preventOutsideClick = true;
        },
        onFocus: function () {
            this.open();
        },
        onCancel: function () {
            this.setVals(this.vals);
            this.close();
            this.trigger('cancel');
        },
        onSave: function () {
            var that = this,
                vals = {};
            that.elem('lang-input').each(function () {
                var $this = $(this),
                    inp = that.findBlockOn($this, 'b-form-input');
                vals[that.getMod($this, 'lang')] = inp.val();
            });
            this.setVals(vals);
            this.close();
            this.trigger('save');
            // по событию change прячутся ошибки
            this.trigger('change');
        },
        setVals: function (vs) {
            var that = this;
            this.vals = vs;
            that.elem('lang-input').each(function () {
                var $this = $(this),
                    inp = that.findBlockOn($this, 'b-form-input'),
                    l = that.getMod($this, 'lang');
                inp.val(vs[l]);
                that.hiddens[l].attr('value', vs[l]);
            });
            var curVal = vs[this.params.currentLang];
            this.elem('input', 'type', 'multilang').val(curVal);
        },

        val: function (vs) {
            if (vs) {
                this.setVals(vs);
            } else {
                return this.vals;
            }
        },

        close: function () {
            this.delMod('open');
        },

        open: function () {
            this.setMod('open', 'yes');
        }
    });
})();
