/*global BEMHTML*/
(function (BEM) {
    'use strict';

    BEM.DOM.decl({block: 'b-form-radio', modName: 'error', modVal: 'yes'}, {
        onSetMod: {
            js: function() {
                var _this = this;
                this.on('change', function () {
                    this.hideError();
                });

                var formBlock = this.findBlockOutside('b-form');

                formBlock && formBlock.on('redraw', function() {
                    if (_this.hideError) {
                        _this.hideError();
                    }
                });
            }
        },

        destruct: function () {
            this._error_popup &&
                this._error_popup.destruct();

            this.__base.apply(this, arguments);
        },

        showError: function(text) {
            if (!this._error_popup) {
                BEM.DOM.append(this.domElem, BEMHTML.apply({
                    block: 'b-popupa',
                    mix: [{block: 'b-form-radio', elem: 'error-hint'}],
                    mods: {theme: 'feffd6', direction: 'up', autoclosable: 'no'},
                    content: [
                        {elem: 'tail'},
                        {elem: 'shadow'},
                        {elem: 'content', content: text || this.params.errorText}
                    ]
                }));

                this._error_popup = this.findBlockOn('error-hint', 'b-popupa');
            } else {
                this._error_popup.setContent(text || this.params.errorText);
            }

            this._error_popup.show(this.domElem);

            this.setMod('error', 'yes');
        },

        hideError: function() {
            this._error_popup &&
                this._error_popup.hide();

            this.delMod('error');
        }
    });
})(BEM);
