(function (BEM) {
    'use strict';

    BEM.DOM.decl({block: 'b-form-select', modName: 'error', modVal: 'yes'}, {

        onSetMod: {
            js: function () {
                this.__base && this.__base.apply(this, arguments);

                var _this = this;
                var formBlock = this._bForm = this.findBlockOutside('b-form');
                var oldVal = this.val();

                var change = this._onChange = function () {
                    if (this._preventErrorHide) {
                        this._preventErrorHide = false;
                        return;
                    }
                    // this is needed because b-form-select
                    // triggers change event after init
                    var newVal = _this.val();
                    if (newVal != oldVal) {
                        oldVal = newVal;
                        if (_this.hideError !== undefined) {
                            _this.hideError();
                        }
                    }
                };

                this.on('change', change);
                if (formBlock) {
                    formBlock.on('redraw', change);
                }
            }
        },

        preventErrorHide: function () {
            this._preventErrorHide = true;
        },

        destruct: function () {
            if (this._bForm && this._bForm.domElem) {
                this._bForm.un('redraw', this._onChange);
            }
            this.__base.apply(this, arguments);
        }
    });

})(BEM);
