/*global BEM:false, BEMHTML:false*/
(function (BEM, identify, extend, pcode) {

    'use strict';

    /*jshint maxlen:false*/
    var ads = [
        {
            url: 'http://maps.yandex.ru',
            title: 'Село Красный Слон на карте',
            body: 'Россия, Ярославская область, Любимский район. Весь мир на Яндекс.Картах.',
            domain: 'maps.yandex.ru',
            punyDomain: 'maps.yandex.ru',
            region: 'Москва',
            warning: '',
            linkTail: '=short-no-warn-img-ad-5',
            debug: ''
        },
        {
            url: 'http://direct.yandex.ru',
            title: 'Сделаем из мухи слона!',
            body: 'Стремительный рост вашему бизнесу обеспечит контекстная реклама в Директе',
            images: [
                ['http://partner-code.yandex.ru/test_pages/img/2_h80.png', 69, 80],
                ['http://partner-code.yandex.ru/test_pages/img/2_h90.png', 77, 90],
                ['http://partner-code.yandex.ru/test_pages/img/2_w80.png', 80, 93],
                ['http://partner-code.yandex.ru/test_pages/img/2_w90.png', 90, 105]
            ],
            domain: 'direct.yandex.ru',
            punyDomain: 'direct.yandex.ru',
            region: 'Москва',
            vcardUrl: 'http://direct.yandex.ru',
            callUrl: 'http://direct.yandex.ru',
            warning: '',
            sitelinks: [
                {title: 'Истории успеха', url: 'http://direct.yandex.ru/'},
                {title: 'Дать объявление', url: 'http://direct.yandex.ru/'},
                {title: 'Помощь менеджера', url: 'http://direct.yandex.ru/'}
            ],
            linkTail: '=short-no-warn-img-ad-1',
            debug: ''
        },
        {
            url: 'http://afisha.yandex.ru',
            title: 'Слон, получивший степень MBA!',
            body: 'Играет в шахматы и занимается йогой! В московском цирке на Цветном бульваре',
            domain: 'afisha.yandex.ru',
            punyDomain: 'afisha.yandex.ru',
            images: [
                ['http://partner-code.yandex.ru/test_pages/img/3_h80.png', 60, 80],
                ['http://partner-code.yandex.ru/test_pages/img/3_h90.png', 68, 90],
                ['http://partner-code.yandex.ru/test_pages/img/3_w80.png', 80, 107],
                ['http://partner-code.yandex.ru/test_pages/img/3_w90.png', 90, 120]
            ],
            region: 'Москва',
            warning: '',
            age: '0+',
            linkTail: '=short-no-warn-img-ad-6',
            debug: ''
        },
        {
            url: 'http://market.yandex.ru',
            title: 'Слонопассит - микстура от стресса.',
            body: 'Эффективный и препарат без привыкания. Будьте спокойны как слон.',
            domain: 'market.yandex.ru',
            punyDomain: 'market.yandex.ru',
            region: 'Москва',
            warning: 'Есть противопоказания. Посоветуйтесь с врачом.',
            linkTail: '=short-no-warn-img-ad-6',
            debug: ''
        },
        {
            url: 'http://metrika.yandex.ru',
            title: 'А слона-то я не приметил!',
            body: 'Со счетчиком Яндекс.Метрики вы будете знать все о посетителях вашего сайта!',
            domain: 'metrika.yandex.ru',
            punyDomain: 'metrika.yandex.ru',
            sitelinks: [
                {title: 'О сервисе', url: 'http://metrika.yandex.ru/'},
                {title: 'Получить счетчик', url: 'http://metrika.yandex.ru/'},
                {title: 'Отчёты', url: 'http://metrika.yandex.ru/'}
            ],
            images: [
                ['http://partner-code.yandex.ru/test_pages/img/1_w80_h80.png', 80, 80],
                ['http://partner-code.yandex.ru/test_pages/img/1_w90_h90.png', 90, 90]
            ],
            region: 'Москва',
            linkTail: '=short-no-warn-img-ad-2'
        },
        {
            url: 'http://partner.yandex.ru',
            title: 'Слоновому сайту слоновый доход',
            body: 'Делимся с лучшими сайтами доходом от размещения контекстной рекламы',
            domain: 'parther.yandex.ru',
            punyDomain: 'parther.yandex.ru',
            region: 'Москва',
            warning: '',
            sitelinks: [
                {title: 'Правила участия', url: 'http://partner.yandex.ru/'},
                {title: 'Продукты', url: 'http://partner.yandex.ru/'},
                {title: 'Служба поддержки', url: 'http://partner.yandex.ru/'}
            ],
            linkTail: '=short-no-warn-img-ad-3',
            debug: ''
        },
        {
            url: 'http://money.yandex.ru',
            title: 'Купи слона – доставка бесплатно!',
            body: 'Еще больше товаров и услуг теперь доступны за Яндекс.Деньги, без переплат!',
            domain: 'money.yandex.ru',
            punyDomain: 'money.yandex.ru',
            region: '',
            warning: '',
            linkTail: '=short-no-warn-img-ad-7',
            debug: ''
        },
        {
            url: 'http://pogoda.yandex.ru',
            title: 'Если слоны летают, это к дождю?',
            body: 'Не верьте в народные приметы. Лучше смотрите погоду на Яндексе.',
            domain: 'pogoda.yandex.ru',
            punyDomain: 'pogoda.yandex.ru',
            images: [
                ['http://partner-code.yandex.ru/test_pages/img/4_h80.png', 107, 80],
                ['http://partner-code.yandex.ru/test_pages/img/4_h90.png', 120, 90],
                ['http://partner-code.yandex.ru/test_pages/img/4_w80.png', 80, 60],
                ['http://partner-code.yandex.ru/test_pages/img/4_w90.png', 90, 68]
            ],
            region: '',
            vcardUrl: 'http://pogoda.yandex.ru',
            callUrl: 'http://pogoda.yandex.ru',
            warning: '',
            linkTail: '=short-no-warn-img-ad-8',
            debug: ''
        }
    ];
    /*jshint maxlen:120*/

    // default: зарезервированное слово в JS,
    // поэтому заключаем в кавычки, чтобы компилятор не ругался
    var blockSettings = {
        'default': {ads: 2},
        '728x90':  {ads: 2},
        '240x400': {ads: 3},
        '160x600': {ads: 4},
        '300x250': {ads: 2}
    };

    /**
     * @param {object} settings
     * @param {object} data
     */
    function makeAd(settings, data) {
        var ad = {},
            viewSitelinks = !Boolean(settings.no_sitelinks),
            viewImages = Boolean(settings.viewImages);

        for (var field in data) {
            if (data.hasOwnProperty(field)) {
                switch (field) {
                case 'no_sitelinks':
                    if (viewSitelinks) {
                        ad[field] = data[field];
                    }
                    break;
                case 'images':
                    if (viewImages) {
                        ad[field] = data[field];
                    }
                    break;
                default:
                    ad[field] = data[field];
                }
            }
        }

        return ad;
    }

    /**
     * @param {number} limit
     * @param {object} settings
     */
    function getPreviewData(limit, settings) {
        return {
            common: {
                // нужно для работы настройки images_first,
                // которая работает только для внутренних площадок
                isYandexPage: settings.isYandexPage,
                linkHead: '',
                domains: []
            },
            direct: {
                ads: ads.slice(0, limit).map(makeAd.bind(null, settings)),
                linkHow: {
                    title: 'Дать объявление',
                    url: 'http://advertising.yandex.ru/welcome/?from=context'
                },
                linkAll: {
                    title: 'Все объявления',
                    url: 'http://direct.yandex.ru/search?from=http://example.com&ref-page=53618'
                },
                directTitle: {
                    title: '<em>Я</em>ндекс.Директ',
                    url: 'http://direct.yandex.ru/?partner'
                }
            }
        };
    }

    BEM.DOM.decl('b-pcode-preview', {
        onSetMod: {
            js: function () {
                this.settings = this.params.settings || {};
                this.blockId = this.params.blockId;
                this.updateData(this.params.data);
            }
        },

        updateSettings: function (settings) {
            this.settings = settings;
            this.render();
        },

        updateData: function (data) {
            var ads;
            if (data == 'preview') {
                ads = this.settings.limit || (blockSettings[this.settings.type] || blockSettings['default'] || {}).ads;
                data = getPreviewData(ads, this.settings);
            }

            if (data && typeof data == 'string') {
                data = JSON.parse(data);
            }

            this.data = data;
            this.render();
        },

        render: function () {
            var id = identify();

            this.domElem.html(BEMHTML.apply({
                block: 'b-pcode-preview',
                elem: 'preview',
                id: id,
                bgColor: this.settings.site_bg_color
            }));

            pcode.render(id, this.settings, this.data, this.blockId);
        }
    });

})(BEM, jQuery.identify, jQuery.extend, BEM.blocks['i-pcode']);
